/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.transform;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.dice_research.opal.licenses.KnowledgeBase;
import org.dice_research.opal.licenses.KnowledgeBases;
import org.dice_research.opal.licenses.utils.CcRel;

public abstract class KbGen {
    public File export() {
        LinkedList<String> commentLines = new LinkedList<String>();
        commentLines.add("Relicensing Combined Datasets (ReCoDa)");
        commentLines.add("https://github.com/dice-group/ReCoDa/");
        if (!this.getAttribueEqualityUris().isEmpty()) {
            commentLines.add("");
            commentLines.add("AttribueEquality:");
            commentLines.add(this.getAttribueEqualityUris().toString());
        }
        if (!this.getPermissionOfDerivatesUris().isEmpty()) {
            commentLines.add("");
            commentLines.add("PermissionOfDerivates:");
            commentLines.add(this.getPermissionOfDerivatesUris().toString());
        }
        KnowledgeBases.KB_DIRECTORY.mkdirs();
        File file = new File(KnowledgeBases.KB_DIRECTORY, this.getTitle() + ".ttl");
        new CcRel(this.getAttribueEqualityUris(), this.getPermissionOfDerivatesUris()).exportTurtle(this.getKnowledgeBase(), file, this.getPrefixes(), commentLines);
        return file;
    }

    public abstract Collection<String> getAttribueEqualityUris();

    public abstract Collection<String> getPermissionOfDerivatesUris();

    public abstract String getTitle();

    public abstract KnowledgeBase getKnowledgeBase();

    public abstract Map<String, String> getPrefixes();
}

