/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.transform;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class GraphExport {
    public static final String SEPARATOR = ";";
    private List<Edge> edges = new LinkedList<Edge>();

    public GraphExport export(File file) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Edge edge : this.edges) {
            stringBuilder.append(edge.source);
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(edge.target);
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(edge.type);
            stringBuilder.append(System.lineSeparator());
        }
        FileUtils.write(file, (CharSequence)stringBuilder, StandardCharsets.UTF_8);
        return this;
    }

    public GraphExport addEdge(String source, String target, String type) {
        this.edges.add(new Edge(source, target, type));
        return this;
    }

    public class Edge {
        String source;
        String target;
        String type;

        public Edge(String source, String target, String type) {
            this.source = source;
            this.target = target;
            this.type = type;
        }
    }
}

