/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.edplcm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.licenses.Attribute;
import org.dice_research.opal.licenses.AttributeFactory;
import org.dice_research.opal.licenses.Attributes;
import org.dice_research.opal.licenses.KnowledgeBase;
import org.dice_research.opal.licenses.License;

public class EdpLcmKnowledgeBase
extends KnowledgeBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String RESOURCE_CSV = "edp-licence-compatibility-matrix-licence-descriptions.csv";
    public static final String URI_PREFIX = "http://example.org/";
    public static final String ATTRIBUTE_ID_SUBLICENSING = EdpLcmKnowledgeBase.attributeIdToUri("Sublicensing");
    public static final String ATTRIBUTE_ID_DERIVATES = EdpLcmKnowledgeBase.attributeIdToUri("Derivative Works");
    public static final String ATTRIBUTE_ID_ALIKE = EdpLcmKnowledgeBase.attributeIdToUri("Share Alike");
    protected boolean isLoaded = false;
    public boolean skipSublicensing = false;
    public boolean skipCcPdm = true;

    @Override
    public Attributes getSortedAttributes() {
        if (!this.isLoaded) {
            try {
                this.load();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        return super.getSortedAttributes();
    }

    @Override
    public LinkedHashMap<String, License> getUrisToLicenses() {
        if (!this.isLoaded) {
            try {
                this.load();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        return super.getUrisToLicenses();
    }

    public EdpLcmKnowledgeBase load() throws IOException {
        LinkedList<String> attributeUris = new LinkedList<String>();
        boolean idsParsed = false;
        boolean typesParsed = false;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(RESOURCE_CSV);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        CSVParser csvRecords = CSVFormat.DEFAULT.parse(bufferedReader);
        for (CSVRecord csvRecord : csvRecords) {
            if (!idsParsed) {
                for (int i = 0; i < csvRecord.size() - 2; ++i) {
                    attributeUris.add(EdpLcmKnowledgeBase.attributeIdToUri(csvRecord.get(i)));
                }
                idsParsed = true;
                continue;
            }
            if (!typesParsed) {
                for (int i = 0; i < csvRecord.size() - 2; ++i) {
                    if (this.skipSublicensing && ((String)attributeUris.get(i)).equals(ATTRIBUTE_ID_SUBLICENSING)) continue;
                    Attribute attribute = AttributeFactory.get().createAttribute(csvRecord.get(i), (String)attributeUris.get(i));
                    if (((String)attributeUris.get(i)).equals(ATTRIBUTE_ID_ALIKE)) {
                        attribute.setTypeAttribueEquality(true);
                    } else if (((String)attributeUris.get(i)).equals(ATTRIBUTE_ID_DERIVATES)) {
                        attribute.setTypePermissionOfDerivates(true);
                    }
                    this.addAttribute(attribute);
                }
                typesParsed = true;
                continue;
            }
            if (this.skipCcPdm && csvRecord.get(csvRecord.size() - 1).equals("CC-PDM 1.0")) continue;
            Attributes attributes = new Attributes();
            for (int i = 0; i < csvRecord.size() - 2; ++i) {
                if (this.skipSublicensing && ((String)attributeUris.get(i)).equals(ATTRIBUTE_ID_SUBLICENSING)) continue;
                Attribute attribute = AttributeFactory.get().createAttribute(super.getSortedAttributes().getUriToAttributeMap().get(attributeUris.get(i)), false);
                try {
                    this.addAttributeValue(attribute, csvRecord.get(i));
                }
                catch (IllegalArgumentException e2) {
                    LOGGER.warn(e2);
                    continue;
                }
                attributes.addAttribute(attribute);
            }
            String uri = csvRecord.get(csvRecord.size() - 2);
            attributes.sort();
            License license = new License().setUri(uri).setName(csvRecord.get(csvRecord.size() - 1)).setAttributes(attributes);
            this.addLicense(license);
        }
        this.isLoaded = true;
        return this;
    }

    protected void addAttributeValue(Attribute attribute, String value) {
        if (!value.equals("0") && !value.equals("1")) {
            throw new IllegalArgumentException("Value is " + value + ", " + attribute);
        }
        attribute.setValue(!value.equals("0"));
    }

    public static String attributeIdToUri(String id) {
        try {
            return new URI(URI_PREFIX + id.replaceAll(" ", "-")).toString();
        }
        catch (URISyntaxException e2) {
            LOGGER.warn(e2);
            return id;
        }
    }

    public String getUriForName(String licenseName) throws IllegalArgumentException, RuntimeException {
        int i;
        String uri = null;
        LinkedList<License> licenses = new LinkedList<License>(this.getLicenses());
        for (i = 0; i < licenses.size(); ++i) {
            if (!((License)licenses.get(i)).getName().equals(licenseName)) continue;
            uri = ((License)licenses.get(i)).getUri();
            break;
        }
        ++i;
        while (i < licenses.size()) {
            if (((License)licenses.get(i)).getName().equals(licenseName)) {
                throw new RuntimeException("Found duplicate name: " + licenseName);
            }
            ++i;
        }
        if (uri == null) {
            throw new IllegalArgumentException("Unknown name: " + licenseName);
        }
        return uri;
    }
}

