/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses.cc;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.licenses.Attributes;
import org.dice_research.opal.licenses.BackMapping;
import org.dice_research.opal.licenses.Execution;
import org.dice_research.opal.licenses.KnowledgeBase;
import org.dice_research.opal.licenses.License;
import org.dice_research.opal.licenses.cc.CcData;
import org.dice_research.opal.licenses.utils.Cfg;

public class CcExperiment {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void main(String[] args) throws Exception {
        new CcExperiment().execute(Cfg.getCcLicenseRdf());
    }

    public void execute(String dataDirectory) {
        if (!new File(dataDirectory).exists()) {
            LOGGER.error("Directory not found: " + new File(dataDirectory).getAbsolutePath());
        }
        CcData data = new CcData().setSourceDirectory(dataDirectory);
        List<File> files = data.getMatixFiles();
        KnowledgeBase knowledgeBase = data.createKnowledgeBase(files);
        LinkedList<ResultContainer> results = new LinkedList<ResultContainer>();
        for (License licenseA : knowledgeBase.getLicenses()) {
            for (License licenseB : knowledgeBase.getLicenses()) {
                ArrayList<License> inputLicenses = new ArrayList<License>(2);
                inputLicenses.add(licenseA);
                inputLicenses.add(licenseB);
                Execution execution = new Execution().setKnowledgeBase(knowledgeBase);
                Attributes resultAttributes = execution.applyOperator(inputLicenses);
                Set<License> resultingLicenses = new BackMapping().getCompatibleLicenses(inputLicenses, resultAttributes, knowledgeBase);
                results.add(new ResultContainer(licenseA, licenseB, resultingLicenses));
            }
        }
        for (ResultContainer result : results) {
            System.out.println(result);
        }
        System.out.println();
        System.out.println(this.toTable(results, true));
        System.out.println();
        System.out.println(this.toTable(results, false));
    }

    private String toTable(List<ResultContainer> results, boolean limitToInput) {
        StringBuilder stringBuilder = new StringBuilder();
        String divider = "\t";
        stringBuilder.append("-");
        stringBuilder.append(divider);
        ResultContainer lastResult = new ResultContainer(null, null, null);
        for (ResultContainer result : results) {
            if (!limitToInput && result.inputContainsNd() || result.licenseA == lastResult.licenseA) continue;
            stringBuilder.append(this.replaceName(result.licenseA.getName()));
            stringBuilder.append(divider);
            lastResult = result;
        }
        lastResult = new ResultContainer(null, null, null);
        for (ResultContainer result : results) {
            if (!limitToInput && result.inputContainsNd()) continue;
            if (result.licenseA != lastResult.licenseA) {
                stringBuilder.append(System.lineSeparator());
                stringBuilder.append(this.replaceName(result.licenseA.getName()));
                stringBuilder.append(divider);
            }
            if (result.resultingLicenses.isEmpty()) {
                stringBuilder.append("-");
            } else {
                HashSet<License> resultingLicenses = new HashSet<License>(result.resultingLicenses);
                if (limitToInput) {
                    LinkedList<License> inputLicenses = new LinkedList<License>();
                    inputLicenses.add(result.licenseA);
                    inputLicenses.add(result.licenseB);
                    resultingLicenses.retainAll(inputLicenses);
                }
                if (resultingLicenses.size() == 8) {
                    stringBuilder.append("all");
                } else {
                    stringBuilder.append((CharSequence)this.setToString(resultingLicenses, divider));
                }
            }
            stringBuilder.append(divider);
            lastResult = result;
        }
        stringBuilder.append(System.lineSeparator());
        return stringBuilder.toString();
    }

    private StringBuilder setToString(Set<License> licenses, String divider) {
        TreeSet<License> orderdLicenses = new TreeSet<License>(new Comparator<License>(){

            @Override
            public int compare(License o1, License o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        orderdLicenses.addAll(licenses);
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (License license : orderdLicenses) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.replaceName(license.getName()));
        }
        return stringBuilder;
    }

    private String replaceName(String name) {
        if (name.equals("mark")) {
            return "PD";
        }
        return name.toUpperCase();
    }

    public class ResultContainer {
        public License licenseA;
        public License licenseB;
        public Set<License> resultingLicenses;

        public ResultContainer(License licenseA, License licenseB, Set<License> resultingLicenses) {
            this.licenseA = licenseA;
            this.licenseB = licenseB;
            this.resultingLicenses = resultingLicenses;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.licenseA.getName());
            stringBuilder.append(", ");
            stringBuilder.append(this.licenseB.getName());
            stringBuilder.append(": ");
            for (int i = 0; i < 16 - this.licenseA.getName().length() - this.licenseB.getName().length(); ++i) {
                stringBuilder.append(" ");
            }
            for (License license : this.resultingLicenses) {
                stringBuilder.append(license.getName());
                stringBuilder.append("  ");
            }
            if (this.resultingLicenses.isEmpty()) {
                stringBuilder.append("-");
            }
            return stringBuilder.toString();
        }

        private boolean inputContainsNd() {
            return this.licenseA.getName().toLowerCase().contains("nd") || this.licenseB.getName().toLowerCase().contains("nd");
        }
    }
}

