/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.dice_research.opal.licenses.Attribute;
import org.dice_research.opal.licenses.Attributes;
import org.dice_research.opal.licenses.License;
import org.dice_research.opal.licenses.utils.ArrayUtil;

public class KnowledgeBase {
    private Attributes attributes = new Attributes();
    private LinkedHashMap<String, License> urisToLicenses = new LinkedHashMap();
    private boolean attributesSorted = false;

    public KnowledgeBase addAttribute(Attribute attribute) {
        this.attributes.addAttribute(attribute);
        this.attributesSorted = false;
        return this;
    }

    public void addLicense(License license) {
        this.urisToLicenses.put(license.getUri(), license);
    }

    public Attributes getSortedAttributes() {
        if (!this.attributesSorted) {
            this.attributes.sort();
        }
        return this.attributes;
    }

    public License getLicense(String uri) {
        return this.urisToLicenses.get(uri);
    }

    public List<License> getLicenses() {
        return new ArrayList<License>(this.urisToLicenses.values());
    }

    public Set<String> getLicenseUris() {
        return this.urisToLicenses.keySet();
    }

    public LinkedHashMap<String, License> getUrisToLicenses() {
        return this.urisToLicenses;
    }

    public String toLines() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Attribute attribute : this.getSortedAttributes().getList()) {
            stringBuilder.append(attribute);
            stringBuilder.append(System.lineSeparator());
        }
        List<License> licenses = this.getLicenses();
        Collections.sort(licenses, new Comparator<License>(){

            @Override
            public int compare(License o1, License o2) {
                return o1.getUri().compareTo(o2.getUri());
            }
        });
        for (License license : licenses) {
            stringBuilder.append(ArrayUtil.intString(license.getAttributes().getValuesArray()));
            stringBuilder.append(" ");
            stringBuilder.append(ArrayUtil.intString(license.getAttributes().getInternalValuesArray()));
            stringBuilder.append(" ");
            stringBuilder.append(license.getUri());
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }
}

