/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dice_research.opal.licenses.AttributeFactory;
import org.dice_research.opal.licenses.Attributes;
import org.dice_research.opal.licenses.BackMapping;
import org.dice_research.opal.licenses.KnowledgeBase;
import org.dice_research.opal.licenses.License;
import org.dice_research.opal.licenses.Operator;

public class Execution {
    private KnowledgeBase knowledgeBase;

    public Set<License> applyBackMapping(List<License> inputLicenses, Attributes setting) {
        return new BackMapping().getCompatibleLicenses(inputLicenses, setting, this.knowledgeBase);
    }

    public Attributes applyOperator(List<License> licenses) {
        if (licenses == null || licenses.isEmpty()) {
            throw new RuntimeException("No license provided");
        }
        ArrayList<boolean[]> internalValues = new ArrayList<boolean[]>(licenses.size());
        for (License license : licenses) {
            internalValues.add(license.getAttributes().getInternalValuesArray());
        }
        boolean[] result = new Operator().compute(internalValues);
        Attributes attributes = new Attributes();
        for (int i = 0; i < this.knowledgeBase.getSortedAttributes().getList().size(); ++i) {
            attributes.addAttribute(AttributeFactory.get().createAttribute(this.knowledgeBase.getSortedAttributes().getList().get(i), false).setValueByInternal(result[i]));
        }
        return attributes;
    }

    public Execution setKnowledgeBase(KnowledgeBase knowledgeBase) {
        this.knowledgeBase = knowledgeBase;
        return this;
    }
}

