/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.licenses;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.dice_research.opal.licenses.Attribute;
import org.dice_research.opal.licenses.AttributeComparator;

public class Attributes {
    private LinkedHashMap<String, Attribute> attributes = new LinkedHashMap();

    public Attributes addAttribute(Attribute attribute) {
        this.attributes.put(attribute.getUri(), attribute);
        return this;
    }

    public Attribute getAttribute(String uri) {
        return this.attributes.get(uri);
    }

    public boolean[] getInternalValuesArray() {
        boolean[] array = new boolean[this.attributes.size()];
        int counter = 0;
        for (Attribute attribute : this.attributes.values()) {
            array[counter++] = attribute.getInternalValue();
        }
        return array;
    }

    public String[] getShortFormArray() {
        String[] array = new String[this.attributes.size()];
        int counter = 0;
        for (Attribute attribute : this.attributes.values()) {
            array[counter++] = attribute.getShortForm();
        }
        return array;
    }

    public List<Attribute> getList() {
        return new ArrayList<Attribute>(this.attributes.values());
    }

    public Set<String> getUris() {
        return this.attributes.keySet();
    }

    public LinkedHashMap<String, Attribute> getUriToAttributeMap() {
        return this.attributes;
    }

    public boolean[] getValuesArray() {
        boolean[] array = new boolean[this.attributes.size()];
        int counter = 0;
        for (Attribute attribute : this.attributes.values()) {
            array[counter++] = attribute.getValue();
        }
        return array;
    }

    public boolean isAttribueEquality() {
        for (Attribute attribute : this.getList()) {
            if (!attribute.isTypeAttribueEquality() || !attribute.getValue().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Attributes sort() {
        List<Attribute> sortedAttributes = this.getList();
        sortedAttributes.sort(new AttributeComparator());
        this.attributes = new LinkedHashMap();
        for (Attribute attribute : sortedAttributes) {
            this.attributes.put(attribute.getUri(), attribute);
        }
        return this;
    }

    public String toLines() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Attribute attribute : this.getList()) {
            stringBuilder.append(attribute);
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.attributes.keySet().toString();
    }
}

