/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.pfunction.PropFuncArg;

public class VarUtils {
    public static Set<Var> getVars(Triple triple) {
        HashSet<Var> x = new HashSet<Var>();
        VarUtils.addVarsFromTriple(x, triple);
        return x;
    }

    public static void addVarsFromTriple(Collection<Var> acc, Triple triple) {
        VarUtils.addVar(acc, triple.getSubject());
        VarUtils.addVar(acc, triple.getPredicate());
        VarUtils.addVar(acc, triple.getObject());
    }

    public static void addVarsFromQuad(Collection<Var> acc, Quad quad) {
        VarUtils.addVar(acc, quad.getGraph());
        VarUtils.addVar(acc, quad.getSubject());
        VarUtils.addVar(acc, quad.getPredicate());
        VarUtils.addVar(acc, quad.getObject());
    }

    public static void addVarsFromTriplePath(Collection<Var> acc, TriplePath tpath) {
        VarUtils.addVar(acc, tpath.getSubject());
        VarUtils.addVar(acc, tpath.getObject());
    }

    public static void addVar(Collection<Var> acc, Node n) {
        if (n == null) {
            return;
        }
        if (n.isVariable()) {
            acc.add(Var.alloc(n));
        } else if (n.isNodeTriple()) {
            Triple t = Node_Triple.triple(n);
            VarUtils.addVarsFromTriple(acc, t);
        }
    }

    public static void addVarNodes(Collection<Var> acc, Collection<Node> nodes) {
        if (nodes == null) {
            return;
        }
        for (Node n : nodes) {
            VarUtils.addVar(acc, n);
        }
    }

    public static void addVarsTriples(Collection<Var> acc, Collection<Triple> triples) {
        for (Triple triple : triples) {
            VarUtils.addVarsFromTriple(acc, triple);
        }
    }

    public static void addVars(Collection<Var> acc, BasicPattern pattern) {
        VarUtils.addVarsTriples(acc, pattern.getList());
    }

    public static void addVars(Collection<Var> acc, Node graphNode, BasicPattern triples) {
        VarUtils.addVar(acc, graphNode);
        VarUtils.addVars(acc, triples);
    }

    public static void addVars(Collection<Var> acc, QuadPattern quadPattern) {
        for (Quad quad : quadPattern.getList()) {
            VarUtils.addVarsFromQuad(acc, quad);
        }
    }

    public static void addVars(Collection<Var> acc, PropFuncArg arg) {
        if (arg.isNode()) {
            VarUtils.addVar(acc, arg.getArg());
        } else {
            VarUtils.addVarNodes(acc, arg.getArgList());
        }
    }
}

