/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.pfunction.library.triple;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.iterator.RX;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropFuncArgType;
import org.apache.jena.sparql.pfunction.PropertyFunctionEval;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;

public class TripleTermFind
extends PropertyFunctionEval {
    public static void init() {
        PropertyFunctionFactory factory = uri -> new TripleTermFind();
        Node uri2 = NodeFactory.createURI("http://arq/find");
        PropertyFunctionRegistry.get().put(uri2.getURI(), factory);
    }

    public TripleTermFind() {
        super(PropFuncArgType.PF_ARG_SINGLE, PropFuncArgType.PF_ARG_SINGLE);
    }

    @Override
    public QueryIterator execEvaluated(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        Node sArg = argSubject.getArg();
        if (!sArg.isNodeTriple()) {
            throw new ExprEvalException("Not a triple term: " + sArg);
        }
        Triple triple = Node_Triple.triple(sArg);
        Node nAssign = argObject.getArg();
        if (!Var.isVar(nAssign)) {
            if (!nAssign.isNodeTriple()) {
                return QueryIterNullIterator.create(execCxt);
            }
            Triple t2 = Node_Triple.triple(nAssign);
            if (t2.equals(triple)) {
                return QueryIterSingleton.create(binding, execCxt);
            }
            return QueryIterNullIterator.create(execCxt);
        }
        Var var = Var.alloc(nAssign);
        QueryIterSingleton input = QueryIterSingleton.create(binding, execCxt);
        QueryIterator qIter = RX.matchTripleStar(input, var, triple, execCxt);
        return qIter;
    }
}

