/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import java.util.Iterator;
import org.apache.jena.riot.system.IteratorStreamRDF;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDFCollectOne;
import org.apache.jena.riot.system.StreamRowRDF;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.Thrift2StreamRDF;
import org.apache.jena.riot.thrift.wire.RDF_StreamRow;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransportException;

public class IteratorThriftRDF
extends IteratorStreamRDF
implements Iterator<StreamRowRDF> {
    private final PrefixMap pmap = PrefixMapFactory.create();
    private final StreamRDFCollectOne collector = new StreamRDFCollectOne(this.pmap);
    private final Thrift2StreamRDF converter = new Thrift2StreamRDF(this.pmap, this.collector);
    private final RDF_StreamRow row = new RDF_StreamRow();
    private final TProtocol protocol;
    private StreamRDFCollectOne slot;
    private boolean finished = false;

    public IteratorThriftRDF(TProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    protected boolean hasMore() {
        return true;
    }

    @Override
    protected StreamRowRDF moveToNext() {
        try {
            this.row.read(this.protocol);
        }
        catch (TTransportException e2) {
            if (e2.getType() == 4) {
                return null;
            }
        }
        catch (TException ex) {
            TRDF.exception(ex);
        }
        TRDF.visit(this.row, this.converter);
        this.row.clear();
        return this.collector.getRow();
    }
}

