/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.common.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;

public abstract class ModelSerialization {
    public static final String DEFAULT_LANGUAGE = "TURTLE";

    public static Model deserialize(byte[] bytes) {
        return ModelSerialization.deserialize(bytes, null, DEFAULT_LANGUAGE);
    }

    public static Model deserialize(byte[] bytes, String base, String lang) {
        Model model = ModelFactory.createDefaultModel();
        model.read((InputStream)new ByteArrayInputStream(bytes), base, lang);
        return model;
    }

    public static byte[] serialize(Model model) {
        return ModelSerialization.serialize(model, DEFAULT_LANGUAGE);
    }

    public static byte[] serialize(Model model, String lang) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        model.write((OutputStream)outStream, lang);
        return outStream.toByteArray();
    }
}

