/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.metadata.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetector;
import opennlp.tools.langdetect.LanguageDetectorME;
import opennlp.tools.langdetect.LanguageDetectorModel;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LangDetector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String MODEL_URL = "https://www-eu.apache.org/dist/opennlp/models/langdetect/1.8.3/langdetect-183.bin";
    private static final String MODEL_FILENAME = "OpenNLP.model.langdetect-183.bin";
    private static LanguageDetector languageDetector;
    private File modelFile;

    public Language predictLanguage(String text) throws IOException {
        this.initialize();
        return languageDetector.predictLanguage((CharSequence)text);
    }

    public Language[] predictLanguages(String text) throws IOException {
        this.initialize();
        return languageDetector.predictLanguages((CharSequence)text);
    }

    public void initialize() throws MalformedURLException, IOException {
        if (this.modelFile == null) {
            this.modelFile = new File(MODEL_FILENAME);
            if (!this.modelFile.exists()) {
                LOGGER.info("Downloading language model to " + this.modelFile.getPath());
                FileUtils.copyURLToFile((URL)new URL(MODEL_URL), (File)this.modelFile, (int)5000, (int)5000);
            }
        }
        if (languageDetector == null) {
            FileInputStream fileInputStream = FileUtils.openInputStream((File)this.modelFile);
            LanguageDetectorModel model = new LanguageDetectorModel((InputStream)fileInputStream);
            languageDetector = new LanguageDetectorME(model);
            fileInputStream.close();
        }
    }
}

