/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.metadata.geo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.SKOS;
import org.dice_research.opal.common.utilities.FileHandler;
import org.dice_research.opal.metadata.geo.GeoContainer;

public class LauNutsExtractor {
    public static final String VERSION_0_3_0 = "0.3.0";
    public static final boolean RESTRICT_TO_ONE_WORD = true;
    public static final boolean LABELS_TO_LOWER_CASE = false;
    public static final String NS_LAUNUTS = "http://projekt-opal.de/launuts/";
    public static final Resource RES_NUTS = ResourceFactory.createResource((String)"http://projekt-opal.de/launuts/NUTS");
    public static final Resource RES_LAU = ResourceFactory.createResource((String)"http://projekt-opal.de/launuts/LAU");
    public static final String NS_GEO = "http://www.w3.org/2003/01/geo/wgs84_pos#";
    public static final Property PROP_LAT = ResourceFactory.createProperty((String)"http://www.w3.org/2003/01/geo/wgs84_pos#", (String)"lat");
    public static final Property PROP_LONG = ResourceFactory.createProperty((String)"http://www.w3.org/2003/01/geo/wgs84_pos#", (String)"long");

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("No file provided.");
            System.exit(1);
        } else {
            File inFile = new File(args[0]);
            File outFile = new File("src/main/resources/places-de-at.txt");
            if (inFile.canRead()) {
                new LauNutsExtractor().extract(inFile, outFile, VERSION_0_3_0);
            } else {
                System.err.println("Can not read: " + inFile.getAbsolutePath());
                System.exit(1);
            }
        }
    }

    private void extract(File inFile, File outFile, String version) {
        GeoContainer container;
        if (version != VERSION_0_3_0) {
            throw new RuntimeException("Version not supported: " + version);
        }
        System.out.println("Input file: " + inFile.getAbsolutePath());
        System.out.println("Output file: " + outFile.getAbsolutePath());
        Model model = FileHandler.importModel((File)inFile);
        if (Boolean.FALSE.booleanValue()) {
            for (Map.Entry<String, Integer> type : this.getTypes(model).entrySet()) {
                System.out.println(type.getKey() + "  " + type.getValue());
            }
        }
        HashMap<String, GeoContainer> containerMap = new HashMap<String, GeoContainer>();
        ResIterator resIterator = model.listSubjectsWithProperty(RDF.type, (RDFNode)RES_NUTS);
        while (resIterator.hasNext()) {
            container = this.extract((Resource)resIterator.next());
            if (!container.hasLabelAndCoords()) continue;
            containerMap.put(container.label, container);
        }
        resIterator = model.listSubjectsWithProperty(RDF.type, (RDFNode)RES_LAU);
        while (resIterator.hasNext()) {
            container = this.extract((Resource)resIterator.next());
            if (!container.hasLabelAndCoords()) continue;
            containerMap.put(container.label, container);
        }
        ArrayList containers = new ArrayList(containerMap.values());
        Collections.sort(containers);
        ArrayList<String> lines = new ArrayList<String>(containers.size() * 3);
        for (GeoContainer container2 : containers) {
            lines.add(container2.label);
            lines.add(String.valueOf(container2.lat));
            lines.add(String.valueOf(container2.lon));
            lines.add(container2.uri);
        }
        try {
            FileUtils.writeLines((File)outFile, lines);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private GeoContainer extract(Resource resource) {
        RDFNode placeNode;
        GeoContainer container = new GeoContainer();
        if (resource.hasProperty(SKOS.prefLabel)) {
            String label = resource.getProperty(SKOS.prefLabel).getObject().asLiteral().getString().trim();
            if (!label.matches("[A-Za-z\\x7f-\\xff]{3,}")) {
                return container;
            }
            container.label = label;
        }
        if (resource.hasProperty(SKOS.relatedMatch) && (placeNode = resource.getProperty(SKOS.relatedMatch).getObject()).isResource()) {
            Resource place = placeNode.asResource();
            container.lat = place.getProperty(PROP_LAT).getObject().asLiteral().getFloat();
            container.lon = place.getProperty(PROP_LONG).getObject().asLiteral().getFloat();
        }
        container.uri = resource.getURI();
        return container;
    }

    protected Map<String, Integer> getTypes(Model model) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        NodeIterator typeNodes = model.listObjectsOfProperty(RDF.type);
        while (typeNodes.hasNext()) {
            RDFNode typeNode = typeNodes.next();
            if (!typeNode.isURIResource()) continue;
            ResIterator resIterator = model.listSubjectsWithProperty(RDF.type, typeNode);
            int counter = 0;
            while (resIterator.hasNext()) {
                resIterator.next();
                ++counter;
            }
            map.put(typeNode.asResource().getURI(), counter);
        }
        return map;
    }
}

