/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.metadata;

import io.github.galbiston.geosparql_jena.implementation.datatype.WKTDatatype;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.DCAT;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.dice_research.opal.common.interfaces.JenaModelProcessor;
import org.dice_research.opal.common.interfaces.ModelProcessor;
import org.dice_research.opal.common.vocabulary.Dcat;
import org.dice_research.opal.common.vocabulary.Opal;
import org.dice_research.opal.metadata.geo.GeoContainer;

public class GeoData
implements ModelProcessor,
JenaModelProcessor {
    public static final String PLACES_FILE = "places-de-at.txt";
    protected static final boolean LABELS_TO_LOWER_CASE = false;
    protected static boolean runIfSpatialAlreadyExists = true;
    protected static SortedMap<String, GeoContainer> geoContainers;
    protected Map<String, String> urisToLabels = new HashMap<String, String>();

    public void processModel(Model model, String datasetUri) throws Exception {
        if (geoContainers == null) {
            this.initialize();
        }
        Resource dataset = model.getResource(datasetUri);
        if (!runIfSpatialAlreadyExists && model.listObjectsOfProperty(dataset, DCTerms.spatial).hasNext()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.collectLiterals(dataset, DCTerms.title, stringBuilder);
        this.collectLiterals(dataset, DCTerms.description, stringBuilder);
        this.collectLiterals(dataset, DCAT.keyword, stringBuilder);
        this.collectLiterals(dataset, DCTerms.spatial, stringBuilder);
        StmtIterator stmtIterator = dataset.listProperties(DCAT.distribution);
        while (stmtIterator.hasNext()) {
            Resource distribution = ((Statement)stmtIterator.next()).getObject().asResource();
            this.collectLiterals(distribution, DCTerms.title, stringBuilder);
            this.collectLiterals(distribution, DCTerms.description, stringBuilder);
        }
        Pattern pattern = Pattern.compile("[A-Za-z\\x7f-\\xff]{3,}");
        Matcher matcher = pattern.matcher(stringBuilder);
        TreeSet<String> words = new TreeSet<String>();
        while (matcher.find()) {
            words.add(matcher.group());
        }
        LinkedList<String> places = new LinkedList<String>();
        for (String word : words) {
            if (!geoContainers.containsKey(word)) continue;
            places.add(word);
        }
        for (String place : places) {
            GeoContainer container = (GeoContainer)geoContainers.get(place);
            Resource placeResource = ResourceFactory.createResource();
            Literal wkt = ResourceFactory.createTypedLiteral((String)("POINT(" + container.lat + " " + container.lon + ")"), (RDFDatatype)WKTDatatype.INSTANCE);
            Literal label = ResourceFactory.createPlainLiteral((String)container.label);
            model.add(placeResource, RDF.type, (RDFNode)DCTerms.Location);
            model.add(placeResource, RDF.type, (RDFNode)Opal.OPAL_LOCATION);
            model.add(placeResource, Dcat.centroid, (RDFNode)wkt);
            model.add(placeResource, RDFS.label, (RDFNode)label);
            model.add(dataset, DCTerms.spatial, (RDFNode)placeResource);
            this.urisToLabels.put(placeResource.getURI(), container.label);
        }
    }

    private void collectLiterals(Resource resource, Property property, StringBuilder stringBuilder) {
        StmtIterator stmtIterator = resource.listProperties(property);
        while (stmtIterator.hasNext()) {
            RDFNode rdfNode = ((Statement)stmtIterator.next()).getObject();
            if (!rdfNode.isLiteral()) continue;
            String string = rdfNode.asLiteral().getLexicalForm();
            stringBuilder.append(string);
            stringBuilder.append(System.lineSeparator());
        }
    }

    @Deprecated
    public Model process(Model model, String datasetUri) throws Exception {
        this.processModel(model, datasetUri);
        return model;
    }

    public void initialize() throws Exception {
        geoContainers = new TreeMap<String, GeoContainer>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return GeoContainer.compare(o1, o2);
            }
        });
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(PLACES_FILE);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            String label = null;
            int counter = 0;
            GeoContainer geoContainer = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (counter == 0) {
                    label = line;
                    geoContainer = new GeoContainer();
                } else if (counter == 1) {
                    geoContainer.lat = Float.valueOf(line).floatValue();
                } else {
                    geoContainer.lon = Float.valueOf(line).floatValue();
                    geoContainer.label = label;
                    geoContainers.put(label, geoContainer);
                }
                counter = (counter + 1) % 3;
            }
        }
    }

    public Map<String, String> getUrisToLabels() {
        return this.urisToLabels;
    }
}

