package org.dice_research.opal.common.constants;

/**
 * Identifiers for catalogs.
 *
 * @author Adrian Wilke
 */
public abstract class Catalogs {

	// --- IDs ---

	/**
	 * ID for https://mcloud.de/
	 */
	public static final String ID_MCLOUD = "mcloud";

	/**
	 * ID for https://www.govdata.de/
	 */
	public static final String ID_GOVDATA = "govdata";

	/**
	 * ID for https://www.europeandataportal.eu/
	 */
	public static final String ID_EUROPEANDATAPORTAL = "europeandataportal";

	/**
	 * ID for https://service.mdm-portal.de/mdm-portal-application/
	 */
	public static final String ID_MDM = "mdm";

	// --- URIs ---

	/**
	 * URI of https://mcloud.de/
	 */
	public static final String URI_MCLOUD = "https://mcloud.de/";

	/**
	 * URI of https://www.govdata.de/
	 */
	public static final String URI_GOVDATA = "https://www.govdata.de/";

	/**
	 * URI of https://www.europeandataportal.eu/
	 */
	public static final String URI_EUROPEANDATAPORTAL = "https://www.europeandataportal.eu/";

	/**
	 * URI of https://service.mdm-portal.de/mdm-portal-application/
	 */
	public static final String URI_MDM = "https://service.mdm-portal.de/";

}