/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.civet.metrics;

import java.util.Arrays;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.civet.Metric;
import org.dice_research.opal.common.vocabulary.Opal;

public class UpdateRateMetric
implements Metric {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DESCRIPTION = "Computes the update rate/frequency. If data is updated at least weekly, 5 stars are awarded. If data is updated at least monthly, 4 stars are awarded.If data is updated at least four times a year, 3 stars are awarded. If data is updated at least once a year, 2 stars are awarded. If data is updated sometimes, 1 star is awarded.If data is never updated or no metadata information is given, 0 stars are awarded.";
    protected static List<String> listUnknown = Arrays.asList("UNKNOWN");
    protected static List<String> listNo = Arrays.asList("OP_DATPRO", "NEVER");
    protected static List<String> listSometimes = Arrays.asList("IRREG", "BIENNIAL", "TRIENNIAL", "DECENNIAL", "TRIDECENNIAL", "BIDECENNIAL", "QUINQUENNIAL");
    protected static List<String> listYearly = Arrays.asList("ANNUAL", "THREETIMESAYEAR");
    protected static List<String> listQuaterly = Arrays.asList("QUARTERLY", "BIMONTHLY", "QUADRENNIAL");
    protected static List<String> listMonthly = Arrays.asList("MONTHLY", "THREETIMESAMONTH", "BIWEEKLY");
    protected static List<String> listWeekly = Arrays.asList("HOURLY", "WEEKLY", "CONT", "DAILY", "UPDATE_CONT", "THREETIMESAWEEK", "CONTINUOUS");

    @Override
    public Integer compute(Model model, String datasetUri) throws Exception {
        Resource dataset = ResourceFactory.createResource((String)datasetUri);
        Statement statement = model.getProperty(dataset, DCTerms.accrualPeriodicity);
        if (statement == null) {
            return 0;
        }
        String updateRate = String.valueOf(statement.getObject()).toUpperCase();
        if (this.stringContainsListEntry(updateRate, listUnknown)) {
            return 0;
        }
        if (this.stringContainsListEntry(updateRate, listNo)) {
            return 0;
        }
        if (this.stringContainsListEntry(updateRate, listSometimes)) {
            return 1;
        }
        if (this.stringContainsListEntry(updateRate, listYearly)) {
            return 2;
        }
        if (this.stringContainsListEntry(updateRate, listQuaterly)) {
            return 3;
        }
        if (this.stringContainsListEntry(updateRate, listMonthly)) {
            return 4;
        }
        if (this.stringContainsListEntry(updateRate, listWeekly)) {
            return 5;
        }
        LOGGER.warn("Unknown update rate for " + datasetUri + ": " + updateRate);
        return null;
    }

    protected boolean stringContainsListEntry(String string, List<String> list) {
        for (String listString : list) {
            if (!string.contains(listString)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getUri() throws Exception {
        return Opal.OPAL_METRIC_UPDATE_RATE.getURI();
    }
}

