/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.civet.metrics;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.DCAT;
import org.apache.jena.vocabulary.DCTerms;
import org.dice_research.opal.civet.Metric;
import org.dice_research.opal.common.vocabulary.Opal;

public class MultipleSerializationsMetric
implements Metric {
    private static final String DESCRIPTION = "Checks, if multiple file formats are provided for download.";

    @Override
    public Integer compute(Model model, String datasetUri) throws Exception {
        Resource dataset = ResourceFactory.createResource((String)datasetUri);
        HashSet<String> extensions = new HashSet<String>();
        HashSet<String> typesAndFormats = new HashSet<String>();
        NodeIterator distributionIterator = model.listObjectsOfProperty(dataset, DCAT.distribution);
        while (distributionIterator.hasNext()) {
            RDFNode distributionNode = distributionIterator.next();
            if (!distributionNode.isResource()) continue;
            Resource distribution = distributionNode.asResource();
            NodeIterator downloadUrlIterator = model.listObjectsOfProperty(distribution, DCAT.downloadURL);
            while (downloadUrlIterator.hasNext()) {
                RDFNode downloadUrl = downloadUrlIterator.next();
                if (!downloadUrl.isURIResource()) continue;
                this.addExtension(downloadUrl.asResource().getURI().toLowerCase(), extensions);
            }
            NodeIterator mediaTypeIterator = model.listObjectsOfProperty(distribution, DCAT.mediaType);
            while (mediaTypeIterator.hasNext()) {
                RDFNode mediaTypeNode = mediaTypeIterator.next();
                if (!mediaTypeNode.isLiteral()) continue;
                typesAndFormats.add(mediaTypeNode.asLiteral().getString());
            }
            NodeIterator formatIterator = model.listObjectsOfProperty(distribution, DCTerms.format);
            while (formatIterator.hasNext()) {
                RDFNode formatNode = formatIterator.next();
                if (!formatNode.isLiteral()) continue;
                typesAndFormats.add(formatNode.asLiteral().getString());
            }
        }
        if (extensions.size() > 1 || typesAndFormats.size() > 1) {
            return 5;
        }
        return 0;
    }

    protected void addExtension(String value, Set<String> set) {
        int dotIndex = value.lastIndexOf(46);
        if (dotIndex != -1 && value.length() - dotIndex <= 5) {
            set.add(value.substring(dotIndex + 1));
        }
    }

    @Override
    public String getDescription() throws Exception {
        return DESCRIPTION;
    }

    @Override
    public String getUri() throws Exception {
        return Opal.OPAL_METRIC_MULTIPLE_SERIALIZATIONS.getURI();
    }
}

