/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.civet.metrics;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.dice_research.opal.civet.Metric;
import org.dice_research.opal.common.vocabulary.Dqv;
import org.dice_research.opal.common.vocabulary.Opal;

public class MetadataQualityMetric
implements Metric {
    private static final String DESCRIPTION = "Calculates the average of all available metric results.";

    @Override
    public Integer compute(Model model, String datasetUri) throws Exception {
        Resource dataset = ResourceFactory.createResource((String)datasetUri);
        int numberOfMeasurements = 0;
        int sumOfMeasurements = 0;
        NodeIterator measurementIterator = model.listObjectsOfProperty(dataset, Dqv.HAS_QUALITY_MEASUREMENT);
        while (measurementIterator.hasNext()) {
            RDFNode valueNode;
            NodeIterator valueIterator;
            RDFNode metric;
            Resource measurement;
            NodeIterator metricIterator;
            RDFNode measurementNode = measurementIterator.next();
            if (!measurementNode.isResource() || (metricIterator = model.listObjectsOfProperty(measurement = measurementNode.asResource(), Dqv.IS_MEASUREMENT_OF)).hasNext() && (metric = metricIterator.next()).isURIResource() && metric.asResource().getURI().equals(Opal.OPAL_METRIC_METADATA_QUALITY.getURI()) || !(valueIterator = model.listObjectsOfProperty(measurement, Dqv.HAS_VALUE)).hasNext() || !(valueNode = valueIterator.next()).isLiteral()) continue;
            try {
                sumOfMeasurements += valueNode.asLiteral().getInt();
                ++numberOfMeasurements;
            }
            catch (Exception exception) {}
        }
        return Math.round(1.0f * (float)sumOfMeasurements / (float)numberOfMeasurements);
    }

    @Override
    public String getDescription() throws Exception {
        return DESCRIPTION;
    }

    @Override
    public String getUri() throws Exception {
        return Opal.OPAL_METRIC_METADATA_QUALITY.getURI();
    }
}

