/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.civet.metrics;

import java.util.HashMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.DCAT;
import org.apache.jena.vocabulary.DCTerms;
import org.dice_research.opal.civet.Metric;
import org.dice_research.opal.common.vocabulary.Opal;

public class DataFormatMetric
implements Metric {
    private static final String DESCRIPTION = "A dataset can have many distributions. Here, individual scores for each distribution are calculated. A distribution gets 5 stars if either the mediatype the format is given. Finally, an average score for the dataset is calculated based on the distribution scores.";

    @Override
    public Integer compute(Model model, String datasetUri) throws Exception {
        Resource dataset = ResourceFactory.createResource((String)datasetUri);
        int distributionCounter = 0;
        HashMap<String, Integer> distributionsAndScores = new HashMap<String, Integer>();
        NodeIterator distributionIterator = model.listObjectsOfProperty(dataset, DCAT.distribution);
        while (distributionIterator.hasNext()) {
            RDFNode distributionNode = distributionIterator.nextNode();
            if (distributionNode.isResource()) {
                Resource distribution = distributionNode.asResource();
                if (distribution.hasProperty(DCTerms.format)) {
                    RDFNode formatNode = distribution.getProperty(DCTerms.format).getObject();
                    if (formatNode.isURIResource() || formatNode.isLiteral() && !formatNode.toString().isEmpty()) {
                        distributionsAndScores.put(distribution.toString(), 5);
                    }
                } else if (distribution.hasProperty(DCAT.mediaType)) {
                    RDFNode mediaTypeNode = distribution.getProperty(DCAT.mediaType).getObject();
                    if (mediaTypeNode.isURIResource() || mediaTypeNode.isLiteral() && !mediaTypeNode.toString().isEmpty()) {
                        distributionsAndScores.put(distribution.toString(), 5);
                    }
                } else {
                    distributionsAndScores.put(distributionNode.toString(), 0);
                }
            } else {
                distributionsAndScores.put(distributionNode.toString(), 0);
            }
            ++distributionCounter;
        }
        float sum = 0.0f;
        for (String key : distributionsAndScores.keySet()) {
            sum += (float)((Integer)distributionsAndScores.get(key)).intValue();
        }
        return (int)Math.ceil(sum / (float)distributionCounter);
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getUri() throws Exception {
        return Opal.OPAL_METRIC_DATA_FORMAT.getURI();
    }
}

