/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.civet;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.common.vocabulary.Dqv;

public abstract class Utils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<Statement> createMetricStatements(Resource dataset, Resource metric, int score) {
        Resource measurement = ResourceFactory.createResource();
        Literal scoreLiteral = ResourceFactory.createTypedLiteral((String)String.valueOf(score), (RDFDatatype)XSDDatatype.XSDinteger);
        ArrayList<Statement> statements = new ArrayList<Statement>(4);
        statements.add(ResourceFactory.createStatement((Resource)dataset, (Property)Dqv.HAS_QUALITY_MEASUREMENT, (RDFNode)measurement));
        statements.add(ResourceFactory.createStatement((Resource)measurement, (Property)RDF.type, (RDFNode)Dqv.QUALITY_MEASUREMENT));
        statements.add(ResourceFactory.createStatement((Resource)measurement, (Property)Dqv.IS_MEASUREMENT_OF, (RDFNode)metric));
        statements.add(ResourceFactory.createStatement((Resource)measurement, (Property)Dqv.HAS_VALUE, (RDFNode)scoreLiteral));
        return statements;
    }

    protected static void removeAllMeasurements(Model model, Resource dataset) {
        NodeIterator measurements = model.listObjectsOfProperty(dataset, Dqv.HAS_QUALITY_MEASUREMENT);
        while (measurements.hasNext()) {
            RDFNode measurement = measurements.next();
            if (measurement.isResource()) {
                measurement.asResource().removeProperties();
                model.remove(dataset, Dqv.HAS_QUALITY_MEASUREMENT, measurement);
                continue;
            }
            LOGGER.warn("Measurement is not a resource: " + measurement.toString() + ", dataset " + dataset.getURI());
        }
    }
}

