/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.civet;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.civet.Metric;
import org.dice_research.opal.civet.Utils;
import org.dice_research.opal.civet.metrics.CategorizationMetric;
import org.dice_research.opal.civet.metrics.DataFormatMetric;
import org.dice_research.opal.civet.metrics.LicenseAvailabilityMetric;
import org.dice_research.opal.civet.metrics.MetadataQualityMetric;
import org.dice_research.opal.civet.metrics.MultipleSerializationsMetric;
import org.dice_research.opal.civet.metrics.UpdateRateMetric;
import org.dice_research.opal.common.interfaces.JenaModelProcessor;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class Civet
implements ModelProcessor,
JenaModelProcessor {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean removeMeasurements = true;
    private boolean logNotComputed = true;

    public void processModel(Model model, String datasetUri) throws Exception {
        Resource dataset = ResourceFactory.createResource((String)datasetUri);
        LOGGER.info("Processing dataset " + datasetUri);
        if (this.removeMeasurements) {
            Utils.removeAllMeasurements(model, dataset);
        }
        for (Metric metric : this.getMetrics()) {
            Integer score = null;
            try {
                score = metric.compute(model, datasetUri);
            }
            catch (Exception e) {
                LOGGER.error("Exception on computing " + metric.getUri() + " for " + datasetUri, (Throwable)e);
                continue;
            }
            if (score == null) {
                if (!this.logNotComputed) continue;
                LOGGER.info("No result for metric " + metric.getUri() + " and dataset " + datasetUri);
                continue;
            }
            model.add(Utils.createMetricStatements(dataset, ResourceFactory.createResource((String)metric.getUri()), score));
        }
    }

    @Deprecated
    public Model process(Model model, String datasetUri) throws Exception {
        this.processModel(model, datasetUri);
        return model;
    }

    public List<Metric> getMetrics() {
        LinkedList<Metric> metrics = new LinkedList<Metric>();
        metrics.add(new CategorizationMetric());
        metrics.add(new DataFormatMetric());
        metrics.add(new LicenseAvailabilityMetric());
        metrics.add(new MultipleSerializationsMetric());
        metrics.add(new UpdateRateMetric());
        metrics.add(new MetadataQualityMetric());
        return metrics;
    }

    public boolean isRemovingMeasurements() {
        return this.removeMeasurements;
    }

    public Civet setRemoveMeasurements(boolean removeMeasurements) {
        this.removeMeasurements = removeMeasurements;
        return this;
    }

    public boolean isLogNotComputed() {
        return this.logNotComputed;
    }

    public void setLogNotComputed(boolean logNotComputed) {
        this.logNotComputed = logNotComputed;
    }
}

