/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.catfish.cleaner;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class LiteralByRegexCleaner {
    private static final Logger logger = LoggerFactory.getLogger(LiteralByRegexCleaner.class);
    private final String regex;

    protected LiteralByRegexCleaner(String regex) {
        this.regex = regex;
    }

    public void cleanByRegex(Model model, Statement statement) {
        try {
            RDFNode object = statement.getObject();
            if (object.isLiteral()) {
                Literal literal = object.asLiteral();
                String value = literal.getString().trim();
                Pattern pattern = Pattern.compile(this.regex);
                Matcher m = pattern.matcher(value);
                if (m.find()) {
                    model.remove(statement);
                    if (m.groupCount() > 1) {
                        Literal modelLiteral = this.createNewLiteral(model, m.group(1), m.group(2));
                        model.add(statement.getSubject(), statement.getPredicate(), (RDFNode)modelLiteral);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in cleaning by regex", (Throwable)e);
        }
    }

    abstract Literal createNewLiteral(Model var1, String var2, String var3);
}

