/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.catfish.cleaner;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.datatypes.xsd.impl.XSDDateType;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.DCAT;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class DateFormatEqualizer
implements ModelProcessor {
    public void processModel(Model model, String datasetUri) throws Exception {
        Resource resource;
        ResIterator resIterator = model.listResourcesWithProperty(RDF.type, (RDFNode)DCAT.Dataset);
        while (resIterator.hasNext()) {
            resource = (Resource)resIterator.next();
            this.clean(model, resource, DCTerms.modified);
            this.clean(model, resource, DCTerms.issued);
        }
        resIterator = model.listResourcesWithProperty(RDF.type, (RDFNode)DCAT.Distribution);
        while (resIterator.hasNext()) {
            resource = (Resource)resIterator.next();
            this.clean(model, resource, DCTerms.modified);
            this.clean(model, resource, DCTerms.issued);
        }
    }

    private void clean(Model model, Resource s, Property p) {
        HashMap<RDFNode, Literal> replacements = new HashMap<RDFNode, Literal>();
        StmtIterator stmtIterator = s.listProperties(p);
        while (stmtIterator.hasNext()) {
            RDFNode rdfNode = ((Statement)stmtIterator.next()).getObject();
            Literal replacement = this.getObjectRelacement(model, s, p, rdfNode);
            if (replacement == null) continue;
            replacements.put(rdfNode, replacement);
        }
        for (Map.Entry entry : replacements.entrySet()) {
            model.add(s, p, (RDFNode)entry.getValue());
            model.remove(s, p, (RDFNode)entry.getKey());
        }
    }

    private Literal getObjectRelacement(Model model, Resource s, Property p, RDFNode o) {
        if (o.isLiteral() && o.asLiteral().getDatatype() instanceof XSDDateType) {
            return model.createTypedLiteral(o.asLiteral().getString() + "T00:00:00", (RDFDatatype)XSDDatatype.XSDdateTime).asLiteral();
        }
        return null;
    }
}

