/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.catfish;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.dice_research.opal.catfish.cleaner.DateFormatEqualizer;
import org.dice_research.opal.catfish.cleaner.EmptyBlankNodeCleaner;
import org.dice_research.opal.catfish.cleaner.FormatCleaner;
import org.dice_research.opal.catfish.cleaner.LiteralCleaner;
import org.dice_research.opal.catfish.cleaner.UriRewriter;
import org.dice_research.opal.catfish.config.CleaningConfig;
import org.dice_research.opal.common.interfaces.JenaModelProcessor;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class Catfish
implements ModelProcessor,
JenaModelProcessor {
    private final CleaningConfig cleaningConfig;
    private String newDatasetUri;

    public Catfish(CleaningConfig cleaningConfig) {
        this.cleaningConfig = cleaningConfig == null ? new CleaningConfig() : cleaningConfig;
    }

    private List<ModelProcessor> getModelProcessors() {
        LinkedList<ModelProcessor> modelProcessors = new LinkedList<ModelProcessor>();
        if (this.cleaningConfig.isCleanEmptyBlankNodes()) {
            modelProcessors.add(new EmptyBlankNodeCleaner());
        }
        if (this.cleaningConfig.isCleanFormats()) {
            modelProcessors.add(new FormatCleaner());
        }
        if (this.cleaningConfig.isCleanLiterals()) {
            modelProcessors.add(new LiteralCleaner());
        }
        if (this.cleaningConfig.isEqualizingDateFormats()) {
            modelProcessors.add(new DateFormatEqualizer());
        }
        if (this.cleaningConfig.getCatalogIdToReplaceUris() != null) {
            modelProcessors.add(new UriRewriter(this.cleaningConfig.getCatalogIdToReplaceUris()));
        }
        return modelProcessors;
    }

    public void processModel(Model model, String datasetUri) {
        List<ModelProcessor> modelProcessors = this.getModelProcessors();
        modelProcessors.forEach(modelProcessor -> {
            try {
                modelProcessor.processModel(model, datasetUri);
                if (modelProcessor instanceof UriRewriter) {
                    this.newDatasetUri = ((UriRewriter)modelProcessor).getNewDatasetUri();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Deprecated
    public Model process(Model model, String datasetUri) {
        this.processModel(model, datasetUri);
        return model;
    }

    public String getNewDatasetUri() {
        return this.newDatasetUri;
    }
}

