/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.catfish.service.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Statement;
import org.dice_research.opal.catfish.service.Cleanable;
import org.dice_research.opal.catfish.service.impl.DataTypeByRegexCleaner;
import org.dice_research.opal.catfish.service.impl.LanguageByRegexCleaner;
import org.dice_research.opal.catfish.service.impl.LiteralByRegexCleaner;
import org.dice_research.opal.catfish.service.impl.NonReadableAndEmptyLiterByRegexCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralCleaner
implements Cleanable {
    private static final Logger logger = LoggerFactory.getLogger(LiteralCleaner.class);
    private final List<LiteralByRegexCleaner> regexCleaners = Arrays.asList(new LanguageByRegexCleaner(), new DataTypeByRegexCleaner(), new NonReadableAndEmptyLiterByRegexCleaner());

    @Override
    public void clean(Model model) {
        try {
            this.regexCleaners.forEach(byRegexCleaner -> {
                List statements = model.listStatements().toList();
                statements.forEach(statement -> byRegexCleaner.cleanByRegex(model, (Statement)statement));
            });
        }
        catch (Exception e) {
            logger.error("Error in cleaning literals", (Throwable)e);
        }
    }
}

