/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.catfish;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.dice_research.opal.catfish.config.CleaningConfig;
import org.dice_research.opal.catfish.service.Cleanable;
import org.dice_research.opal.catfish.service.impl.DateFormatEqualizer;
import org.dice_research.opal.catfish.service.impl.EmptyBlankNodeCleaner;
import org.dice_research.opal.catfish.service.impl.FormatCleaner;
import org.dice_research.opal.catfish.service.impl.LiteralCleaner;
import org.dice_research.opal.common.interfaces.JenaModelProcessor;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class Catfish
implements ModelProcessor,
JenaModelProcessor {
    private final CleaningConfig cleaningConfig;

    public Catfish(CleaningConfig cleaningConfig) {
        this.cleaningConfig = cleaningConfig == null ? new CleaningConfig() : cleaningConfig;
    }

    private List<Cleanable> getCleaners() {
        ArrayList<Cleanable> ret = new ArrayList<Cleanable>();
        if (this.cleaningConfig.isCleanEmptyBlankNodes()) {
            ret.add(new EmptyBlankNodeCleaner());
        }
        if (this.cleaningConfig.isCleanFormats()) {
            ret.add(new FormatCleaner());
        }
        if (this.cleaningConfig.isCleanLiterals()) {
            ret.add(new LiteralCleaner());
        }
        if (this.cleaningConfig.isEqualizingDateFormats()) {
            ret.add(new DateFormatEqualizer());
        }
        return ret;
    }

    public void processModel(Model model, String datasetUri) {
        List<Cleanable> cleaners = this.getCleaners();
        cleaners.forEach(cleaner -> cleaner.clean(model));
    }

    @Deprecated
    public Model process(Model model, String datasetUri) {
        this.processModel(model, datasetUri);
        return model;
    }
}

