/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.catfish.cleaner;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.DCAT;
import org.apache.jena.vocabulary.RDF;
import org.dice_research.opal.catfish.utils.SubjectObjectSelector;
import org.dice_research.opal.common.interfaces.ModelProcessor;
import org.dice_research.opal.common.vocabulary.Opal;

public class UriRewriter
implements ModelProcessor {
    private String catalog;
    private String newDatasetUri;

    public UriRewriter(String catalog) throws RuntimeException {
        if (catalog == null || catalog.trim().isEmpty()) {
            throw new RuntimeException("No catalog given");
        }
        this.catalog = catalog;
    }

    public void processModel(Model model, String datasetUri) throws Exception {
        for (Resource dataset : this.collectResourcesOfType(model, DCAT.Dataset)) {
            Resource newDataset = this.replaceAll(model, dataset, DCAT.Dataset);
            if (!dataset.getURI().equals(datasetUri)) continue;
            this.newDatasetUri = newDataset.getURI();
            this.addCatalog(model, newDataset);
        }
        for (Resource distribution : this.collectResourcesOfType(model, DCAT.Distribution)) {
            this.replaceAll(model, distribution, DCAT.Distribution);
        }
    }

    private void addCatalog(Model model, Resource dataset) {
        String catalogUri = null;
        if (this.catalog.equals("europeandataportal")) {
            catalogUri = "https://www.europeandataportal.eu/";
        } else if (this.catalog.equals("govdata")) {
            catalogUri = "https://www.govdata.de/";
        } else if (this.catalog.equals("mcloud")) {
            catalogUri = "https://mcloud.de/";
        } else if (this.catalog.equals("mdm")) {
            catalogUri = "https://service.mdm-portal.de/";
        }
        if (catalogUri != null) {
            model.add(dataset, DCAT.catalog, (RDFNode)ResourceFactory.createResource((String)catalogUri));
        }
    }

    private List<Resource> collectResourcesOfType(Model model, Resource resourceType) {
        LinkedList<Resource> resources = new LinkedList<Resource>();
        StmtIterator stmtIterator = model.listStatements(null, RDF.type, (RDFNode)resourceType);
        while (stmtIterator.hasNext()) {
            resources.add(((Statement)stmtIterator.next()).getSubject());
        }
        return resources;
    }

    private Resource replaceAll(Model model, Resource resource, Resource resourceType) {
        Resource newResource = this.getNewResource(resource.getURI(), resourceType.getURI());
        LinkedList<Statement> stmts = new LinkedList<Statement>();
        StmtIterator stmtIterator = model.listStatements((Selector)new SubjectObjectSelector(resource));
        while (stmtIterator.hasNext()) {
            stmts.add((Statement)stmtIterator.next());
        }
        for (Statement stmt : stmts) {
            if (stmt.getSubject().equals((Object)resource) && stmt.getObject().equals(resource)) {
                model.add(newResource, stmt.getPredicate(), (RDFNode)newResource);
                model.remove(resource, stmt.getPredicate(), (RDFNode)resource);
                continue;
            }
            if (stmt.getSubject().equals((Object)resource)) {
                model.add(newResource, stmt.getPredicate(), stmt.getObject());
                model.remove(resource, stmt.getPredicate(), stmt.getObject());
                continue;
            }
            if (!stmt.getObject().equals(resource)) continue;
            model.add(stmt.getSubject(), stmt.getPredicate(), (RDFNode)newResource);
            model.remove(stmt.getSubject(), stmt.getPredicate(), (RDFNode)resource);
        }
        model.add(newResource, Opal.PROP_ORIGINAL_URI, (RDFNode)resource);
        return newResource;
    }

    private Resource getNewResource(String uriToReplace, String resourceTypeUri) {
        String newUri;
        if (resourceTypeUri.equals(DCAT.Dataset.getURI())) {
            newUri = org.dice_research.opal.common.utilities.UriRewriter.getOpalDatasetUri((String)this.catalog, (String)uriToReplace);
        } else if (resourceTypeUri.equals(DCAT.Distribution.getURI())) {
            newUri = org.dice_research.opal.common.utilities.UriRewriter.getOpalDistributionUri((String)this.catalog, (String)uriToReplace);
        } else {
            throw new RuntimeException("Unknown type: " + resourceTypeUri);
        }
        return ResourceFactory.createResource((String)newUri);
    }

    public String getNewDatasetUri() {
        return this.newDatasetUri;
    }
}

