/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.catfish.cleaner;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.DCAT;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.dice_research.opal.catfish.cleaner.LiteralCleaner;
import org.dice_research.opal.catfish.utils.Traverser;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class TitleLanguageFilter
implements ModelProcessor {
    public static final String DE = "de";
    public static final String DE_TRANSLATED = "de-";
    public static final String EN = "en";
    public static final String EN_TRANSLATED = "en-";

    public void processModel(Model model, String datasetUri) throws Exception {
        Resource dataset = model.getResource(datasetUri);
        if (!this.titleInEnglishAndGerman(dataset)) {
            model.remove(Traverser.traverse(model, dataset));
            if (!(model.listStatements(null, RDF.type, (RDFNode)DCAT.Dataset).hasNext() || model.listSubjectsWithProperty(DCAT.dataset).hasNext() || model.listObjectsOfProperty(DCAT.dataset).hasNext())) {
                model.removeAll();
            }
        }
    }

    private boolean titleInEnglishAndGerman(Resource dataset) {
        boolean titleInEnglish = false;
        boolean titleInGerman = false;
        StmtIterator titleStmtIterator = dataset.listProperties(DCTerms.title);
        while (titleStmtIterator.hasNext()) {
            RDFNode title = ((Statement)titleStmtIterator.next()).getObject();
            String language = LiteralCleaner.getLanguageOfLiteral(title);
            if (title.isLiteral() && title.asLiteral().getString().trim().isEmpty()) continue;
            if (this.isLanguageDe(language)) {
                titleInGerman = true;
                continue;
            }
            if (!this.isLanguageEn(language)) continue;
            titleInEnglish = true;
        }
        return titleInEnglish && titleInGerman;
    }

    private boolean isLanguageDe(String language) {
        return language.equals(DE) || language.startsWith(DE_TRANSLATED);
    }

    private boolean isLanguageEn(String language) {
        return language.equals(EN) || language.startsWith(EN_TRANSLATED);
    }
}

