/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.catfish.cleaner;

import java.util.Arrays;
import java.util.List;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Statement;
import org.dice_research.opal.catfish.cleaner.DataTypeByRegexCleaner;
import org.dice_research.opal.catfish.cleaner.LanguageByRegexCleaner;
import org.dice_research.opal.catfish.cleaner.LiteralByRegexCleaner;
import org.dice_research.opal.catfish.cleaner.NonReadableAndEmptyLiterByRegexCleaner;
import org.dice_research.opal.common.interfaces.ModelProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralEncodingCleaner
implements ModelProcessor {
    private static final Logger logger = LoggerFactory.getLogger(LiteralEncodingCleaner.class);
    private final List<LiteralByRegexCleaner> regexCleaners = Arrays.asList(new LanguageByRegexCleaner(), new DataTypeByRegexCleaner(), new NonReadableAndEmptyLiterByRegexCleaner());

    public void processModel(Model model, String datasetUri) throws Exception {
        try {
            this.regexCleaners.forEach(byRegexCleaner -> {
                List statements = model.listStatements().toList();
                statements.forEach(statement -> byRegexCleaner.cleanByRegex(model, (Statement)statement));
            });
        }
        catch (Exception e) {
            logger.error("Error in cleaning literals", (Throwable)e);
        }
    }
}

