/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.catfish.cleaner;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.Statement;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class LiteralCleaner
implements ModelProcessor {
    private boolean removeEmptyLiterals;
    private Set<String> whitelistExactLanguages;
    private Set<String> whitelistLanguagePrefixes;

    public LiteralCleaner() {
        this.removeEmptyLiterals = true;
        this.whitelistExactLanguages = new HashSet<String>();
        this.whitelistExactLanguages.add("de");
        this.whitelistExactLanguages.add("en");
        this.whitelistExactLanguages.add("");
        this.whitelistLanguagePrefixes = new HashSet<String>();
        this.whitelistLanguagePrefixes.add("de-");
        this.whitelistLanguagePrefixes.add("en-");
    }

    public LiteralCleaner(boolean removeEmptyLiterals, Set<String> whitelistExactLanguages, Set<String> whitelistLanguagePrefixes) {
        if (whitelistExactLanguages == null || whitelistLanguagePrefixes == null) {
            throw new NullPointerException();
        }
        this.removeEmptyLiterals = removeEmptyLiterals;
        this.whitelistExactLanguages = whitelistExactLanguages;
        this.whitelistLanguagePrefixes = whitelistLanguagePrefixes;
    }

    public void processModel(Model model, String datasetUri) throws Exception {
        model.remove(model.listStatements(new Selector(){

            public boolean test(Statement stmt) {
                if (!stmt.getObject().isLiteral()) {
                    return false;
                }
                if (LiteralCleaner.this.removeEmptyLiterals && stmt.getObject().asLiteral().getString().trim().isEmpty()) {
                    return true;
                }
                String language = LiteralCleaner.getLanguageOfLiteral(stmt.getObject());
                if (LiteralCleaner.this.whitelistExactLanguages.contains(language)) {
                    return false;
                }
                for (String prefix : LiteralCleaner.this.whitelistLanguagePrefixes) {
                    if (!language.startsWith(prefix)) continue;
                    return false;
                }
                return true;
            }

            public boolean isSimple() {
                return false;
            }

            public Resource getSubject() {
                return null;
            }

            public Property getPredicate() {
                return null;
            }

            public RDFNode getObject() {
                return null;
            }
        }));
    }

    public static String getLanguageOfLiteral(RDFNode literal) {
        int index;
        String language = "";
        if (literal.isLiteral() && (language = literal.asLiteral().getLanguage()).trim().isEmpty() && (index = literal.toString().lastIndexOf("\"@")) != -1 && (language = literal.toString().substring(index + 2)).contains("\"")) {
            language = "";
        }
        return language;
    }
}

