/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.catfish.checker;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.DCAT;

public class DistributionAccessChecker {
    public boolean checkModel(Model model, String datasetUri) {
        Resource dataset = model.getResource(datasetUri);
        StmtIterator datasetStmtIterator = dataset.listProperties(DCAT.distribution);
        while (datasetStmtIterator.hasNext()) {
            Resource distribution;
            RDFNode distributionRdfNode = ((Statement)datasetStmtIterator.next()).getObject();
            if (!distributionRdfNode.isResource() || !this.hasValidUri(distribution = distributionRdfNode.asResource(), DCAT.accessURL) && !this.hasValidUri(distribution, DCAT.downloadURL)) continue;
            return true;
        }
        return false;
    }

    private boolean hasValidUri(Resource distribution, Property property) {
        StmtIterator stmtIterator = distribution.asResource().listProperties(property);
        if (stmtIterator.hasNext()) {
            try {
                new URI(((Statement)stmtIterator.next()).getObject().toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }
}

