/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.batch.writer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.batch.writer.RdfWriter;

public class RdfFileWriter
implements RdfWriter {
    private static final Logger LOGGER = LogManager.getLogger();
    public File directory;
    public Lang lang;
    public String title;
    public int maxModels;
    File file;
    private FileOutputStream fileOutputStream = null;
    private int modelCounter = 0;
    private int fileCounter = 1;

    @Override
    public RdfWriter write(Model model) {
        if (this.fileOutputStream == null) {
            this.file = new File(this.directory, this.title + "-" + this.fileCounter + "." + (String)this.lang.getFileExtensions().get(0));
            if (this.file.exists()) {
                this.file.delete();
            }
            try {
                this.fileOutputStream = new FileOutputStream(this.file, true);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        RDFDataMgr.write((OutputStream)this.fileOutputStream, (Model)model, (Lang)this.lang);
        ++this.modelCounter;
        if (this.modelCounter == this.maxModels) {
            this.finish();
        }
        return this;
    }

    @Override
    public RdfWriter finish() {
        if (this.file != null) {
            LOGGER.info("Wrote: " + this.file.getAbsolutePath() + " (" + this.modelCounter + " datasets)");
            try {
                this.fileOutputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.file = null;
        this.fileOutputStream = null;
        this.modelCounter = 0;
        ++this.fileCounter;
        return this;
    }
}

