/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.batch.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.vocabulary.FOAF;
import org.apache.jena.vocabulary.DCAT;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.batch.writer.RdfWriter;

public class RdfFileBufferWriter
implements RdfWriter {
    private static final Logger LOGGER = LogManager.getLogger();
    public File directory;
    public Lang lang;
    public String title;
    public int maxModels;
    File file;
    Model exportModel = null;
    private int modelCounter = 0;
    private int fileCounter = 1;

    @Override
    public RdfWriter write(Model model) {
        if (this.exportModel == null) {
            this.file = new File(this.directory, this.title + "-" + this.fileCounter + "." + (String)this.lang.getFileExtensions().get(0));
            if (this.file.exists()) {
                this.file.delete();
            }
            this.exportModel = ModelFactory.createDefaultModel();
            this.exportModel.setNsPrefix("rdf", RDF.getURI());
            this.exportModel.setNsPrefix("rdfs", RDFS.getURI());
            this.exportModel.setNsPrefix("dct", DCTerms.getURI());
            this.exportModel.setNsPrefix("dcat", DCAT.getURI());
            this.exportModel.setNsPrefix("foaf", FOAF.getURI());
            this.exportModel.setNsPrefix("dqv", "http://www.w3.org/ns/dqv#");
            this.exportModel.setNsPrefix("opal", "http://projekt-opal.de/");
            this.exportModel.setNsPrefix("dataset", "http://projekt-opal.de/dataset/");
            this.exportModel.setNsPrefix("distribution", "http://projekt-opal.de/distribution/");
            this.exportModel.setNsPrefix("metric", "http://metric.projekt-opal.de/");
        }
        this.exportModel.add(model);
        ++this.modelCounter;
        if (this.modelCounter == this.maxModels) {
            this.finish();
        }
        return this;
    }

    @Override
    public RdfWriter finish() {
        if (this.exportModel != null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
                RDFDataMgr.write((OutputStream)fileOutputStream, (Model)this.exportModel, (Lang)this.lang);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            LOGGER.info("Wrote: " + this.file.getAbsolutePath() + " (" + this.modelCounter + " datasets)");
        }
        this.file = null;
        this.exportModel = null;
        this.modelCounter = 0;
        ++this.fileCounter;
        return this;
    }
}

