/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.batch.reader;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.vocabulary.DCAT;
import org.apache.jena.vocabulary.RDF;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.batch.reader.RdfReader;
import org.dice_research.opal.batch.reader.RdfReaderResult;

public class RdfFileReader
implements RdfReader {
    private static final Logger LOGGER = LogManager.getLogger();
    private File file = null;
    private String graphName = null;
    private ResIterator datasetIterator = null;

    public RdfFileReader setFile(File file) {
        this.file = file;
        return this;
    }

    public RdfFileReader setGraphName(String graphName) {
        this.graphName = graphName;
        return this;
    }

    public File getFile() {
        return this.file;
    }

    public String getGraphName() {
        return this.graphName;
    }

    @Override
    public boolean hasNext() {
        if (this.datasetIterator == null) {
            this.initialize();
        }
        return this.datasetIterator.hasNext();
    }

    @Override
    public RdfReaderResult next() {
        if (this.datasetIterator == null) {
            this.initialize();
        }
        Model model = ModelFactory.createDefaultModel();
        Resource dataset = (Resource)this.datasetIterator.next();
        this.addStatements(model, dataset, new HashSet<String>());
        return new RdfReaderResult().setModel(model).setDatasetUri(dataset.getURI());
    }

    private void initialize() {
        if (this.file == null) {
            throw new RuntimeException("No file specified");
        }
        if (!this.file.canRead()) {
            throw new RuntimeException("Can not read: " + this.file.getAbsolutePath());
        }
        this.datasetIterator = RDFLanguages.isQuads((Lang)RDFLanguages.filenameToLang((String)this.file.getName())) && this.graphName != null ? RdfFileReader.loadNquadsGraph(this.file, this.graphName).listResourcesWithProperty(RDF.type, (RDFNode)DCAT.Dataset) : RdfFileReader.loadFile(this.file).listResourcesWithProperty(RDF.type, (RDFNode)DCAT.Dataset);
    }

    private void addStatements(Model model, Resource resource, Set<String> processedResourceUris) {
        processedResourceUris.add(resource.getURI());
        StmtIterator stmtIterator = resource.listProperties();
        while (stmtIterator.hasNext()) {
            Statement statement = (Statement)stmtIterator.next();
            model.add(statement);
            if (!statement.getObject().isResource() || processedResourceUris.contains(statement.getObject().asResource().getURI())) continue;
            this.addStatements(model, statement.getObject().asResource(), processedResourceUris);
        }
    }

    private static Model loadFile(File file) {
        LOGGER.debug("Reading: " + file.getAbsolutePath() + " " + file.length() / 1000000L + " MB");
        Model model = RDFDataMgr.loadModel((String)file.toURI().toString());
        LOGGER.debug("Read model, size: " + model.size());
        return model;
    }

    private static Model loadNquadsGraph(File nquadsFile, String graphName) {
        LOGGER.debug("Reading: " + nquadsFile.getAbsolutePath() + " " + nquadsFile.length() / 1000000L + " MB");
        Dataset dataset = RDFDataMgr.loadDataset((String)nquadsFile.toURI().toString(), (Lang)Lang.NQUADS);
        Model model = dataset.getNamedModel(graphName);
        LOGGER.debug("Got graph '" + graphName + "', size: " + model.size());
        return model;
    }
}

