/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.batch.processor;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.DCTerms;
import org.dice_research.opal.batch.construction.internal.StringCounter;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class TitleLanguageCounter
implements ModelProcessor {
    private StringCounter literalLanguageCounter;
    private StringCounter germanEnglishCounter;
    public static final String DE = "de";
    public static final String EN = "en";
    public static final String DE_EN = "de+en";
    public static final String EMPTY = "[EMPTY]";

    public TitleLanguageCounter(StringCounter literalLanguageCounter, StringCounter germanEnglishCounter) {
        this.literalLanguageCounter = literalLanguageCounter;
        this.germanEnglishCounter = germanEnglishCounter;
    }

    public void processModel(Model model, String datasetUri) throws Exception {
        Resource dataset = model.getResource(datasetUri);
        this.processTriples(dataset, DCTerms.title);
    }

    private void processTriples(Resource s, Property p) {
        StmtIterator stmtIterator = s.listProperties(p);
        boolean hasDe = false;
        boolean hasEn = false;
        while (stmtIterator.hasNext()) {
            int index;
            RDFNode o = ((Statement)stmtIterator.next()).getObject();
            if (!o.isLiteral()) continue;
            String literalLanguage = o.asLiteral().getLanguage();
            if (literalLanguage.trim().isEmpty() && (index = o.toString().lastIndexOf("\"@")) != -1) {
                literalLanguage = o.toString().substring(index + 2);
            }
            if (literalLanguage.trim().isEmpty()) {
                literalLanguage = EMPTY;
            }
            this.literalLanguageCounter.increment(literalLanguage);
            if (o.asLiteral().getString().trim().isEmpty()) continue;
            if (literalLanguage.toLowerCase().startsWith(DE)) {
                hasDe = true;
                this.germanEnglishCounter.increment(DE);
                continue;
            }
            if (!literalLanguage.toLowerCase().startsWith(EN)) continue;
            hasEn = true;
            this.germanEnglishCounter.increment(EN);
        }
        if (hasDe && hasEn) {
            this.germanEnglishCounter.increment(DE_EN);
        }
    }
}

