/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.batch.processor;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.DCAT;
import org.dice_research.opal.batch.construction.internal.StringCounter;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class PropertyCounter
implements ModelProcessor {
    public boolean includeDataset = true;
    public boolean includeDistributions = true;
    public boolean countResources = true;
    public boolean countLiterals = true;
    public boolean countBlankNodes = true;
    public String blankNodeKey = "[BLANK]";
    private StringCounter counter;
    private Property property;

    public PropertyCounter(StringCounter counter, String propertyUri) {
        this.counter = counter;
        this.property = ResourceFactory.createProperty((String)propertyUri);
    }

    public PropertyCounter(StringCounter counter, Property property) {
        this.counter = counter;
        this.property = property;
    }

    public void processModel(Model model, String datasetUri) throws Exception {
        Resource dataset = model.getResource(datasetUri);
        if (this.includeDataset) {
            this.count(dataset, this.property);
        }
        if (this.includeDistributions) {
            StmtIterator stmtIterator = dataset.listProperties(DCAT.distribution);
            while (stmtIterator.hasNext()) {
                RDFNode object = ((Statement)stmtIterator.next()).getObject();
                if (!object.isResource()) continue;
                this.count(object.asResource(), this.property);
            }
        }
    }

    private void count(Resource subject, Property property) {
        StmtIterator stmtIterator = subject.listProperties(property);
        while (stmtIterator.hasNext()) {
            RDFNode object = ((Statement)stmtIterator.next()).getObject();
            if (object.isURIResource() && this.countResources) {
                this.counter.increment(object.asResource().getURI());
                continue;
            }
            if (object.isLiteral() && this.countLiterals) {
                this.counter.increment(object.asLiteral().getString());
                continue;
            }
            if (!object.isAnon() || !this.countBlankNodes) continue;
            this.counter.increment(this.blankNodeKey);
        }
    }
}

