/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.batch.processor;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.DCAT;
import org.apache.jena.vocabulary.DCTerms;
import org.dice_research.opal.batch.construction.internal.StringCounter;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class DateFormatCounter
implements ModelProcessor {
    public boolean includeDataset = true;
    public boolean includeDistributions = true;
    public boolean countResources = true;
    public boolean countBlankNodes = true;
    public String blankNodeKey = "[BLANK]";
    public String resourceKey = "[RESOURCE]";
    public Character number = Character.valueOf('0');
    public Character letter = Character.valueOf('l');
    public Character unknown = Character.valueOf('?');
    private StringCounter datatypeCounter;
    private StringCounter dateFormatCounter;
    private StringCounter stringFormatCounter;

    public DateFormatCounter(StringCounter datatypeCounter, StringCounter dateFormatCounter, StringCounter stringFormatCounter) {
        this.datatypeCounter = datatypeCounter;
        this.dateFormatCounter = dateFormatCounter;
        this.stringFormatCounter = stringFormatCounter;
    }

    public void processModel(Model model, String datasetUri) throws Exception {
        Resource dataset = model.getResource(datasetUri);
        if (this.includeDataset) {
            this.processTriples(dataset, DCTerms.issued);
            this.processTriples(dataset, DCTerms.modified);
        }
        if (this.includeDistributions) {
            StmtIterator stmtIterator = dataset.listProperties(DCAT.distribution);
            while (stmtIterator.hasNext()) {
                RDFNode object = ((Statement)stmtIterator.next()).getObject();
                if (!object.isResource()) continue;
                this.processTriples(object.asResource(), DCTerms.issued);
                this.processTriples(object.asResource(), DCTerms.modified);
            }
        }
    }

    private void processTriples(Resource s, Property p) {
        StmtIterator stmtIterator = s.listProperties(p);
        while (stmtIterator.hasNext()) {
            RDFNode o = ((Statement)stmtIterator.next()).getObject();
            if (o.isLiteral()) {
                int index;
                String string;
                String datatypeUri = o.asLiteral().getDatatypeURI();
                this.datatypeCounter.increment(datatypeUri);
                if (datatypeUri.equals("http://www.w3.org/2001/XMLSchema#date")) {
                    string = o.asLiteral().getString();
                    index = string.lastIndexOf("\"^^");
                    if (index != -1) {
                        string = string.substring(1, index);
                    }
                    this.dateFormatCounter.increment(this.getStringFormat(string));
                    continue;
                }
                if (!datatypeUri.equals("http://www.w3.org/2001/XMLSchema#string")) continue;
                string = o.asLiteral().getString();
                index = string.lastIndexOf("\"^^");
                if (index != -1) {
                    string = string.substring(1, index);
                }
                this.stringFormatCounter.increment(this.getStringFormat(string));
                continue;
            }
            if (this.countResources && o.isURIResource()) {
                this.datatypeCounter.increment(this.resourceKey);
                continue;
            }
            if (!this.countBlankNodes || !o.isAnon()) continue;
            this.datatypeCounter.increment(this.blankNodeKey);
        }
    }

    private String getStringFormat(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            char i = c;
            if (i >= '0' && i <= '9') {
                stringBuilder.append(this.number);
                continue;
            }
            if (i >= 'A' && i <= 'Z') {
                stringBuilder.append(this.letter);
                continue;
            }
            if (i >= 'a' && i <= 'z') {
                stringBuilder.append(this.letter);
                continue;
            }
            if (c == '\u00e4' || c == '\u00f6' || c == '\u00fc' || c == '\u00df') {
                stringBuilder.append(this.letter);
                continue;
            }
            if (c == '\u00c4' || c == '\u00d6' || c == '\u00dc') {
                stringBuilder.append(this.letter);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

