/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.batch.construction.opal;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.batch.configuration.Cfg;
import org.dice_research.opal.batch.configuration.CfgException;
import org.dice_research.opal.batch.construction.AbstractConstructor;
import org.dice_research.opal.catfish.Catfish;
import org.dice_research.opal.catfish.config.CleaningConfig;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class CatfishConstructor
extends AbstractConstructor {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<String> getCatalogIds() {
        LinkedList<String> catalogIds = new LinkedList<String>();
        catalogIds.add("europeandataportal");
        catalogIds.add("govdata");
        catalogIds.add("mcloud");
        catalogIds.add("mdm");
        return catalogIds;
    }

    public static String getCatalogId(File file) {
        String catalogId = null;
        for (String catalog : CatfishConstructor.getCatalogIds()) {
            if (!file.getName().contains(catalog)) continue;
            if (catalogId == null) {
                catalogId = catalog;
                continue;
            }
            throw new CfgException("The input " + file.getName() + " contains multiple entries of " + CatfishConstructor.getCatalogIds());
        }
        if (catalogId == null) {
            for (String catalog : CatfishConstructor.getCatalogIds()) {
                if (!file.getAbsolutePath().contains(catalog)) continue;
                if (catalogId == null) {
                    catalogId = catalog;
                    continue;
                }
                throw new CfgException("The input " + file.getName() + " contains multiple entries of " + CatfishConstructor.getCatalogIds());
            }
        }
        if (catalogId == null) {
            throw new RuntimeException("Please ensure the file name " + file.getName() + " contains one entry of " + CatfishConstructor.getCatalogIds());
        }
        return catalogId;
    }

    @Override
    public boolean addModelProcessor(Cfg cfg, List<ModelProcessor> processors) {
        return super.addModelProcessor(cfg, processors, "run.catfish");
    }

    @Override
    public ModelProcessor createModelProcessor(Cfg cfg) {
        CleaningConfig cleaningConfig = new CleaningConfig().setCleanEmptyBlankNodes(cfg.getBoolean("catfish.cleanEmptyBlankNodes")).setRemoveNonDeEnEmptyTitleLiterals(cfg.getBoolean("catfish.removeNonDeEnEmptyTitles")).setRemoveNonDeEnTitleDatasets(cfg.getBoolean("catfish.removeNonDeEn")).setCleanLiterals(cfg.getBoolean("catfish.cleanLiterals")).setCleanFormats(cfg.getBoolean("catfish.cleanFormats")).setEqualizeDateFormats(cfg.getBoolean("catfish.equalizeDateFormats"));
        if (cfg.has("catfish.replaceUrisCatalog")) {
            String catalogId = cfg.get("catfish.replaceUrisCatalog");
            if (CatfishConstructor.getCatalogIds().contains(catalogId)) {
                cleaningConfig.setCatalogIdToReplaceUris(catalogId);
            } else {
                LOGGER.error("Unknown catalog: '" + catalogId + "'. Will not rewrite URIs.");
            }
        }
        return new Catfish(cleaningConfig);
    }
}

