/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.batch.construction.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.batch.configuration.Cfg;
import org.dice_research.opal.batch.configuration.Filenames;
import org.dice_research.opal.batch.construction.AbstractConstructor;
import org.dice_research.opal.batch.construction.Constructor;
import org.dice_research.opal.batch.construction.internal.StringCounter;
import org.dice_research.opal.batch.processor.TitleLanguageCounter;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class TitleLanguageCounterConstructor
extends AbstractConstructor {
    private static final Logger LOGGER = LogManager.getLogger();
    private StringCounter literalLanguageCounter;
    private StringCounter germanEnglishCounter;

    @Override
    public boolean addModelProcessor(Cfg cfg, List<ModelProcessor> processors) {
        return super.addModelProcessor(cfg, processors, "statistics.titleLanguages");
    }

    @Override
    public ModelProcessor createModelProcessor(Cfg cfg) {
        this.literalLanguageCounter = new StringCounter();
        this.germanEnglishCounter = new StringCounter();
        return new TitleLanguageCounter(this.literalLanguageCounter, this.germanEnglishCounter);
    }

    @Override
    public Constructor finish(Cfg cfg) {
        if (cfg.getBoolean("statistics.titleLanguages")) {
            this.write(this.literalLanguageCounter, Filenames.getFile(cfg, "title-languages.csv"));
            this.write(this.germanEnglishCounter, Filenames.getFile(cfg, "title-languages-de-en.csv"));
        }
        return this;
    }

    private void write(StringCounter stringCounter, File file) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Long> entry : stringCounter.getCounterSortedByValue().entrySet()) {
            stringBuilder.append(entry.getValue());
            stringBuilder.append(",");
            stringBuilder.append(entry.getKey());
            stringBuilder.append(System.lineSeparator());
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.error("Error on writing literal languages counter", (Throwable)e);
        }
    }
}

