/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.batch.construction.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.dice_research.opal.batch.configuration.Cfg;
import org.dice_research.opal.batch.configuration.Filenames;
import org.dice_research.opal.batch.construction.AbstractConstructor;
import org.dice_research.opal.batch.construction.Constructor;
import org.dice_research.opal.batch.processor.ModelTripleCounter;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class InfoConstructor
extends AbstractConstructor {
    private static final Logger LOGGER = LogManager.getLogger();
    private long startTime;
    private long endTime;
    private ModelTripleCounter modelTripleCounter;

    @Override
    public boolean addModelProcessor(Cfg cfg, List<ModelProcessor> processors) {
        processors.add(this.createModelProcessor(cfg));
        return true;
    }

    @Override
    public ModelProcessor createModelProcessor(Cfg cfg) {
        this.startTime = System.currentTimeMillis();
        this.modelTripleCounter = new ModelTripleCounter();
        return this.modelTripleCounter;
    }

    @Override
    public Constructor finish(Cfg cfg) {
        this.endTime = System.currentTimeMillis();
        float runSeconds = 1.0f * (float)(this.endTime - this.startTime) / 1000.0f;
        StringBuilder stringBuilder = new StringBuilder();
        if (cfg.has("info")) {
            stringBuilder.append("Info:                ");
            stringBuilder.append(cfg.get("info"));
            stringBuilder.append(System.lineSeparator());
            stringBuilder.append(System.lineSeparator());
        }
        stringBuilder.append("Start:               " + new Date(this.startTime).toString());
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("Runtime (seconds):   " + runSeconds);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("Processed datasets:  " + this.modelTripleCounter.models);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("Datasets per second: " + 1.0f * (float)this.modelTripleCounter.models / runSeconds);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("Processed triples:   " + this.modelTripleCounter.triples);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("Triples per dataset: " + 1.0f * (float)this.modelTripleCounter.triples / (float)this.modelTripleCounter.models);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(System.lineSeparator());
        long writtenModels = cfg.getLong("internal.writtenModels");
        long writtenTriples = cfg.getLong("internal.writtenTriples");
        stringBuilder.append("Written datasets:    " + writtenModels);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("Datasets per second: " + 1.0f * (float)writtenModels / runSeconds);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("Written triples:     " + writtenTriples);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("Triples per dataset: " + 1.0f * (float)writtenTriples / (float)writtenModels);
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("Processor:           https://github.com/projekt-opal/batch");
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("Version:             " + this.getVersionName());
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append("Configuration:");
        stringBuilder.append(System.lineSeparator());
        stringBuilder.append(cfg.toString());
        try (FileOutputStream fos = new FileOutputStream(Filenames.getFile(cfg, "info.txt"));){
            fos.write(stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.error("Error on writing info file", (Throwable)e);
        }
        return super.finish(cfg);
    }

    private String getVersionNameFromManifest() {
        InputStream manifestStream = this.getClass().getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
        if (manifestStream != null) {
            try {
                return new Manifest(manifestStream).getMainAttributes().getValue("versionName");
            }
            catch (IOException e) {
                return "unknown";
            }
        }
        return "unknown";
    }

    private String getVersionName() {
        if (new File("pom.xml").exists()) {
            try {
                return new MavenXpp3Reader().read((Reader)new FileReader("pom.xml")).getVersion();
            }
            catch (IOException | XmlPullParserException e) {
                return "unknown";
            }
        }
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/org.dice-research.opal/batch/pom.properties"));
            if (properties.containsKey("version")) {
                return properties.getProperty("version");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getVersionNameFromManifest();
    }
}

