/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.batch.construction.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.batch.configuration.Cfg;
import org.dice_research.opal.batch.construction.AbstractConstructor;
import org.dice_research.opal.batch.construction.Constructor;
import org.dice_research.opal.batch.construction.internal.StringCounter;
import org.dice_research.opal.batch.processor.PropertyCounter;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public abstract class AbstractCounterConstructor
extends AbstractConstructor {
    private static final Logger LOGGER = LogManager.getLogger();
    private StringCounter stringCounter;

    public abstract String getCfgKey();

    public abstract String getProperty();

    public abstract File getFile(Cfg var1);

    @Override
    public boolean addModelProcessor(Cfg cfg, List<ModelProcessor> processors) {
        return super.addModelProcessor(cfg, processors, this.getCfgKey());
    }

    @Override
    public ModelProcessor createModelProcessor(Cfg cfg) {
        this.stringCounter = new StringCounter();
        return new PropertyCounter(this.stringCounter, this.getProperty());
    }

    @Override
    public Constructor finish(Cfg cfg) {
        if (cfg.getBoolean(this.getCfgKey())) {
            try (FileOutputStream fos = new FileOutputStream(this.getFile(cfg));){
                for (Map.Entry<String, Long> entry : this.stringCounter.getCounterSortedByValue().entrySet()) {
                    fos.write(entry.getValue().toString().getBytes(StandardCharsets.UTF_8));
                    fos.write(",".getBytes(StandardCharsets.UTF_8));
                    fos.write(entry.getKey().getBytes(StandardCharsets.UTF_8));
                    fos.write(System.lineSeparator().getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error on writing counter " + this.getCfgKey(), (Throwable)e);
            }
        }
        return this;
    }
}

