/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.batch.construction;

import java.util.LinkedList;
import java.util.List;
import org.dice_research.opal.batch.configuration.Cfg;
import org.dice_research.opal.batch.construction.Constructor;
import org.dice_research.opal.batch.construction.internal.DateFormatCounterConstructor;
import org.dice_research.opal.batch.construction.internal.InfoConstructor;
import org.dice_research.opal.batch.construction.internal.LanguageCounterConstructor;
import org.dice_research.opal.batch.construction.internal.ThemeCounterConstructor;
import org.dice_research.opal.batch.construction.internal.TitleLanguageCounterConstructor;
import org.dice_research.opal.batch.construction.opal.CatfishConstructor;
import org.dice_research.opal.batch.construction.opal.CivetConstructor;
import org.dice_research.opal.batch.construction.opal.GeoDataConstructor;
import org.dice_research.opal.batch.construction.opal.LanguageDetectionConstructor;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class ConstructorManager {
    private List<Constructor> constructors = new LinkedList<Constructor>();
    private List<ModelProcessor> modelProcessors = new LinkedList<ModelProcessor>();

    public static ConstructorManager create() {
        ConstructorManager constructorManager = new ConstructorManager();
        constructorManager.addConstructor(new InfoConstructor());
        constructorManager.addConstructor(new CatfishConstructor());
        constructorManager.addConstructor(new LanguageDetectionConstructor());
        constructorManager.addConstructor(new GeoDataConstructor());
        constructorManager.addConstructor(new CivetConstructor());
        constructorManager.addConstructor(new DateFormatCounterConstructor());
        constructorManager.addConstructor(new LanguageCounterConstructor());
        constructorManager.addConstructor(new TitleLanguageCounterConstructor());
        constructorManager.addConstructor(new ThemeCounterConstructor());
        return constructorManager;
    }

    public ConstructorManager addConstructor(Constructor constructor) {
        this.constructors.add(constructor);
        return this;
    }

    public List<Constructor> getConstructors() {
        return this.constructors;
    }

    public ConstructorManager createModelProcessors(Cfg cfg) {
        for (Constructor constructor : this.constructors) {
            constructor.addModelProcessor(cfg, this.modelProcessors);
        }
        return this;
    }

    public ConstructorManager addModelProcessor(ModelProcessor modelProcessor) {
        this.modelProcessors.add(modelProcessor);
        return this;
    }

    public List<ModelProcessor> getModelProcessors() {
        return this.modelProcessors;
    }
}

