/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.batch.configuration;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.batch.configuration.CfgException;

public class Cfg {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DEFAULT_CONFIGURATION_FILE = "default.properties";
    private Properties properties;

    public Cfg() {
        this(new File(DEFAULT_CONFIGURATION_FILE));
    }

    public Cfg(File file) {
        LOGGER.info("Configuration: " + file.getAbsolutePath());
        if (!file.canRead()) {
            throw new CfgException("Can not read configuration file: " + file.getAbsolutePath());
        }
        this.properties = new Properties();
        try {
            this.properties.load(new FileReader(file));
        }
        catch (IOException e) {
            throw new CfgException(e);
        }
    }

    public String get(String key) {
        return this.properties.getProperty(key).trim();
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.properties.getProperty(key).trim());
    }

    public long getLong(String key) {
        return Long.parseLong(this.properties.getProperty(key).trim());
    }

    public List<String> getKeys(String prefix) {
        LinkedList<String> keys = new LinkedList<String>();
        Enumeration<?> propertyNames = this.properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = propertyNames.nextElement().toString();
            if (!propertyName.startsWith(prefix)) continue;
            keys.add(propertyName);
        }
        return keys;
    }

    public boolean has(String key) {
        return this.properties.containsKey(key) && !this.properties.getProperty(key).trim().isEmpty();
    }

    public Cfg set(String key, String value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public String toString() {
        int maxlength = 0;
        for (Object key : this.properties.keySet()) {
            if (key.toString().length() <= maxlength) continue;
            maxlength = key.toString().length();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object key : new TreeSet<Object>(this.properties.keySet())) {
            stringBuilder.append(key.toString());
            for (int i = 0; i <= maxlength - key.toString().length(); ++i) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.properties.get(key));
            stringBuilder.append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }
}

