/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.opal.batch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dice_research.opal.batch.configuration.Cfg;
import org.dice_research.opal.batch.configuration.CfgException;
import org.dice_research.opal.batch.construction.Constructor;
import org.dice_research.opal.batch.construction.ConstructorManager;
import org.dice_research.opal.batch.construction.opal.CatfishConstructor;
import org.dice_research.opal.batch.reader.RdfFileReader;
import org.dice_research.opal.batch.reader.RdfReaderResult;
import org.dice_research.opal.batch.writer.DummyWriter;
import org.dice_research.opal.batch.writer.OutputInfo;
import org.dice_research.opal.batch.writer.RdfFileBufferWriter;
import org.dice_research.opal.batch.writer.RdfWriter;
import org.dice_research.opal.catfish.Catfish;
import org.dice_research.opal.catfish.checker.DistributionAccessChecker;
import org.dice_research.opal.common.interfaces.ModelProcessor;

public class Batch {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<File> inputs;
    private String inputGraph;
    private File outputDirectory;
    private String outputTitle;
    private Lang outputLanguage;
    private int outputSize;
    private RdfWriter rdfWriter;
    private List<ModelProcessor> modelProcessors;
    private OutputInfo outputInfo = new OutputInfo();

    public static void main(String[] args) throws Exception {
        try {
            if (args.length == 0) {
                new Batch().execute(new Cfg());
            } else {
                new Batch().execute(new Cfg(new File(args[0])));
            }
        }
        catch (CfgException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
    }

    public void execute(Cfg cfg) throws Exception {
        this.execute(cfg, ConstructorManager.create());
    }

    public void execute(Cfg cfg, ConstructorManager constructorManager) throws Exception {
        this.checkInput(cfg);
        this.checkOutput(cfg);
        this.modelProcessors = constructorManager.createModelProcessors(cfg).getModelProcessors();
        this.setRdfWriter(cfg);
        for (File input : this.inputs) {
            if (input.isDirectory()) {
                this.processDirectory(input);
                continue;
            }
            this.processFile(input);
        }
        this.rdfWriter.finish();
        cfg.set("internal.writtenModels", Long.valueOf(this.outputInfo.writtenModels).toString());
        cfg.set("internal.writtenTriples", Long.valueOf(this.outputInfo.writtenTriples).toString());
        for (Constructor constructor : constructorManager.getConstructors()) {
            constructor.finish(cfg);
        }
        this.createAdditionalFiles(cfg);
        LOGGER.info("Finished. Results: " + this.outputDirectory.getAbsolutePath());
    }

    private void checkInput(Cfg cfg) {
        if (!cfg.has("io.input")) {
            throw new CfgException("No input set.");
        }
        this.inputs = new LinkedList<File>();
        for (String inputString : cfg.get("io.input").split("\\|")) {
            File file = new File(inputString.trim());
            if (!file.canRead()) {
                throw new CfgException("Can not read input: " + file.getAbsolutePath());
            }
            this.inputs.add(file);
        }
        if (cfg.has("io.inputGraph")) {
            this.inputGraph = cfg.get("io.inputGraph");
        }
        if (cfg.getBoolean("run.catfish") && cfg.getBoolean("catfish.replaceUrisCatalogByFilename")) {
            String catalogId = CatfishConstructor.getCatalogId(this.inputs.get(0));
            cfg.set("catfish.replaceUrisCatalog", catalogId);
            LOGGER.info("Using catalog '" + catalogId + "' for replacing URIs.");
        }
    }

    private void checkOutput(Cfg cfg) {
        if (!cfg.has("io.outputDirectory")) {
            throw new CfgException("No output directory set.");
        }
        this.outputDirectory = new File(cfg.get("io.outputDirectory"));
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        if (!this.outputDirectory.canWrite()) {
            throw new CfgException("Can not write output directory: " + this.outputDirectory.getAbsolutePath());
        }
        if (!cfg.has("io.outputTitle")) {
            throw new CfgException("No output title set.");
        }
        this.outputTitle = cfg.get("io.outputTitle");
        if (!cfg.has("io.outputFormat")) {
            throw new CfgException("No output format set.");
        }
        this.outputLanguage = RDFLanguages.fileExtToLang((String)cfg.get("io.outputFormat"));
        if (this.outputLanguage == null) {
            throw new CfgException("Unknown output format: " + cfg.get("io.outputFormat"));
        }
        if (!cfg.has("io.outputSize")) {
            throw new CfgException("No output size set.");
        }
        this.outputSize = Integer.parseInt(cfg.get("io.outputSize"));
    }

    private void processDirectory(File inputDirectory) {
        final Set<String> fileExtensions = this.getFileExtensions();
        File[] inputFiles = inputDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String ext = name.substring(name.lastIndexOf(".") + 1);
                if (fileExtensions.contains(ext)) {
                    return true;
                }
                LOGGER.info("Skipping unknown file extension " + name);
                return false;
            }
        });
        LOGGER.info("Processing " + inputFiles.length + " files in " + inputDirectory.getAbsolutePath());
        for (File inputFile : inputFiles) {
            try {
                this.processFile(inputFile);
            }
            catch (Exception e) {
                LOGGER.error("Error in processing " + inputFile.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    private void processFile(File inputFile) throws Exception {
        RdfFileReader rdfFileReader = new RdfFileReader().setFile(inputFile);
        if (this.inputGraph != null) {
            rdfFileReader.setGraphName(this.inputGraph);
        }
        while (rdfFileReader.hasNext()) {
            RdfReaderResult result = rdfFileReader.next();
            String datasetUri = result.getDatasetUri();
            if (!new DistributionAccessChecker().checkModel(result.getModel(), datasetUri)) continue;
            datasetUri = this.processModel(result.getModel(), result.getDatasetUri());
            if (!new DistributionAccessChecker().checkModel(result.getModel(), datasetUri)) continue;
            this.rdfWriter.write(result.getModel());
            ++this.outputInfo.writtenModels;
            this.outputInfo.writtenTriples += result.getModel().size();
        }
    }

    private String processModel(Model model, String datasetUri) throws Exception {
        String currentDatasetUri = datasetUri;
        for (ModelProcessor modelProcessor : this.modelProcessors) {
            modelProcessor.processModel(model, currentDatasetUri);
            if (!(modelProcessor instanceof Catfish) || ((Catfish)modelProcessor).getNewDatasetUri() == null) continue;
            currentDatasetUri = ((Catfish)modelProcessor).getNewDatasetUri();
        }
        return currentDatasetUri;
    }

    private Set<String> getFileExtensions() {
        TreeSet<String> fileExtensions = new TreeSet<String>();
        for (Lang lang : RDFLanguages.getRegisteredLanguages()) {
            fileExtensions.addAll(lang.getFileExtensions());
        }
        return fileExtensions;
    }

    private RdfWriter setRdfWriter(Cfg cfg) {
        this.rdfWriter = null;
        if (cfg.getBoolean("io.outputWrite")) {
            RdfFileBufferWriter rdfFileWriter = new RdfFileBufferWriter();
            rdfFileWriter.directory = this.outputDirectory;
            rdfFileWriter.title = this.outputTitle;
            rdfFileWriter.lang = this.outputLanguage;
            rdfFileWriter.maxModels = this.outputSize;
            this.rdfWriter = rdfFileWriter;
        } else {
            this.rdfWriter = new DummyWriter();
        }
        return this.rdfWriter;
    }

    private void createAdditionalFiles(Cfg cfg) {
        if (cfg.getBoolean("add.labels")) {
            try {
                IOUtils.copy((InputStream)this.getClass().getResourceAsStream("opal-themes-labels.ttl"), (OutputStream)new FileOutputStream(new File(this.outputDirectory, "labels-themes.ttl")));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

