/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.enexa.vocab;

import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;

public class IANAMediaType {
    protected static final String IRI = "https://www.iana.org/assignments/media-types/";

    public static String getIRI() {
        return IRI;
    }

    public static String contentType2Iri(String contentType) {
        if (contentType != null) {
            return IRI + contentType;
        }
        return null;
    }

    public static String iri2ContentType(String iri) {
        if (iri != null && iri.startsWith(IRI)) {
            return iri.substring(IRI.length());
        }
        return null;
    }

    public static Lang iri2Lang(String iri) {
        return RDFLanguages.contentTypeToLang((String)IANAMediaType.iri2ContentType(iri));
    }

    public static String lang2Iri(Lang lang) {
        if (lang != null) {
            return IRI + lang.getContentType().getContentTypeStr();
        }
        return null;
    }

    public static Resource lang2Resource(Lang lang) {
        if (lang != null) {
            return ResourceFactory.createResource((String)IANAMediaType.lang2Iri(lang));
        }
        return null;
    }

    public static String resource2ContentType(Resource ianaResource) {
        if (ianaResource != null && ianaResource.isURIResource()) {
            return IANAMediaType.iri2ContentType(ianaResource.getURI());
        }
        return null;
    }

    public static Lang resource2Lang(Resource ianaResource) {
        if (ianaResource != null && ianaResource.isURIResource()) {
            return IANAMediaType.iri2Lang(ianaResource.getURI());
        }
        return null;
    }
}

