/*
 * Decompiled with CFR 0.152.
 */
package org.dice_research.enexa.utils;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnexaPathUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnexaPathUtils.class);
    public static final String SHARED_DIR_PREFIX = "enexa-dir://";

    public static String translateEnexa2LocalPath(String enexaPath, String sharedDir) {
        return EnexaPathUtils.getCheckedShared(sharedDir) + enexaPath.substring(SHARED_DIR_PREFIX.length());
    }

    public static String translateLocal2EnexaPath(File localFile, String sharedDir) {
        return EnexaPathUtils.translateLocal2EnexaPath(localFile.getAbsolutePath(), sharedDir);
    }

    public static String translateLocal2EnexaPath(String localPath, String sharedDir) {
        String shared = EnexaPathUtils.getCheckedShared(sharedDir);
        if (!localPath.startsWith(shared)) {
            LOGGER.error("The given local path {} is not in the shared directory {}. Returning null.", (Object)localPath, (Object)sharedDir);
            return null;
        }
        return SHARED_DIR_PREFIX + localPath.substring(shared.length());
    }

    protected static String getCheckedShared(String sharedDir) {
        return sharedDir.endsWith(File.separator) ? sharedDir : sharedDir + File.separator;
    }
}

