/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.IOException;
import java.io.Reader;
import xtc.parser.Column;
import xtc.parser.ParseError;
import xtc.parser.ParseException;
import xtc.parser.Result;
import xtc.tree.Locatable;
import xtc.tree.Location;
import xtc.util.Action;
import xtc.util.Pair;

public abstract class ParserBase {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final int FIRST_LINE = 1;
    public static final int FIRST_COLUMN = 1;
    public static final int INIT_SIZE = 4096;
    public static final int INCR_SIZE = 4096;
    protected Reader yyReader;
    protected int yyCount;
    protected boolean yyEOF;
    protected char[] yyData;
    protected Column[] yyColumns;

    public ParserBase(Reader reader2, String file) {
        this(reader2, file, 4095);
    }

    public ParserBase(Reader reader2, String file, int size2) {
        if (null == file) {
            throw new NullPointerException("Null file");
        }
        if (size2 < 0) {
            throw new IllegalArgumentException("Negative size: " + size2);
        }
        this.yyReader = reader2;
        this.yyCount = 0;
        this.yyEOF = false;
        this.yyData = new char[size2 + 1];
        this.yyColumns = new Column[size2 + 1];
        Column c = this.newColumn();
        c.file = file;
        c.seenCR = false;
        c.line = 1;
        c.column = 1;
        this.yyColumns[0] = c;
    }

    public final void resetTo(int index) {
        int i;
        if (0 > index) {
            throw new IndexOutOfBoundsException("Parser index: " + index);
        }
        if (0 == index) {
            return;
        }
        if (index >= this.yyCount) {
            throw new IndexOutOfBoundsException("Parser index: " + index);
        }
        Column c1 = this.column(index);
        Column c2 = this.newColumn();
        c2.file = c1.file;
        c2.seenCR = c1.seenCR;
        c2.line = c1.line;
        c2.column = c1.column;
        this.yyColumns[0] = c2;
        int length = this.yyCount - index;
        System.arraycopy(this.yyData, index, this.yyData, 0, length);
        for (i = length; i < this.yyCount; ++i) {
            this.yyData[i] = '\u0000';
        }
        for (i = 1; i < this.yyCount; ++i) {
            this.yyColumns[i] = null;
        }
        this.yyCount = length;
    }

    private void growBy(int incr) {
        char[] oldValues = this.yyData;
        this.yyData = new char[oldValues.length + incr];
        System.arraycopy(oldValues, 0, this.yyData, 0, oldValues.length);
        Column[] oldColumns = this.yyColumns;
        this.yyColumns = new Column[oldColumns.length + incr];
        System.arraycopy(oldColumns, 0, this.yyColumns, 0, oldColumns.length);
    }

    protected abstract Column newColumn();

    protected final Column column(int index) {
        Column c;
        if (this.yyColumns.length == index) {
            this.growBy(4096);
        }
        if (null != (c = this.yyColumns[index])) {
            return c;
        }
        Column last2 = null;
        for (int start2 = index; start2 >= 0 && null == (last2 = this.yyColumns[start2]); --start2) {
        }
        int line = last2.line;
        int column = last2.column;
        boolean seenCR = last2.seenCR;
        block6: for (int i = start2; i < index; ++i) {
            switch (this.yyData[i]) {
                case '\t': {
                    column = (column >> 3) + 1 << 3;
                    seenCR = false;
                    continue block6;
                }
                case '\n': {
                    if (!seenCR) {
                        ++line;
                        column = 1;
                    }
                    seenCR = false;
                    continue block6;
                }
                case '\r': {
                    ++line;
                    column = 1;
                    seenCR = true;
                    continue block6;
                }
                default: {
                    ++column;
                    seenCR = false;
                }
            }
        }
        c = this.newColumn();
        c.file = last2.file;
        c.seenCR = seenCR;
        c.line = line;
        c.column = column;
        this.yyColumns[index] = c;
        return c;
    }

    protected final int character(int index) throws IOException {
        int incr;
        if (this.yyEOF) {
            if (index < this.yyCount - 1) {
                return this.yyData[index];
            }
            if (index < this.yyCount) {
                return -1;
            }
            throw new IndexOutOfBoundsException("Parser index: " + index);
        }
        if (index < this.yyCount) {
            return this.yyData[index];
        }
        if (index != this.yyCount) {
            throw new IndexOutOfBoundsException("Parser index: " + index);
        }
        int c = this.yyReader.read();
        int n = incr = -1 == c ? 1 : 4096;
        if (this.yyData.length <= this.yyCount) {
            this.growBy(incr);
        }
        if (-1 == c) {
            this.yyEOF = true;
        } else {
            this.yyData[index] = (char)c;
        }
        ++this.yyCount;
        return c;
    }

    protected final String difference(int start2, int end) {
        return start2 == end ? "" : new String(this.yyData, start2, end - start2);
    }

    public final boolean isEOF(int index) {
        return this.yyEOF && index == this.yyCount - 1;
    }

    public final String lineAt(int index) throws IOException {
        if (0 > index) {
            throw new IndexOutOfBoundsException("Parser index: " + index);
        }
        if (0 < index && 10 == this.character(index) && 13 == this.character(index - 1)) {
            --index;
        }
        int start2 = index;
        int end = index;
        int c = this.character(end);
        while (-1 != c && 13 != c && 10 != c) {
            c = this.character(++end);
        }
        while (0 != start2 && 13 != (c = this.character(start2 - 1)) && 10 != c) {
            --start2;
        }
        return this.difference(start2, end);
    }

    public final Location location(int index) {
        Column c = this.column(index);
        return new Location(c.file, c.line, c.column);
    }

    protected final void setLocation(int index, String file, int line, int column) {
        if (null == file) {
            throw new NullPointerException("Null file");
        }
        if (0 > line) {
            throw new IllegalArgumentException("Invalid line number: " + line);
        }
        if (1 > column) {
            throw new IllegalArgumentException("Invalid column number: " + column);
        }
        if (index < 0 || this.yyCount <= index) {
            throw new IndexOutOfBoundsException("Parser index: " + index);
        }
        Column c = this.yyColumns[index];
        if (null != c) {
            if (file.equals(c.file) && line == c.line && column == c.column) {
                return;
            }
            if (0 != index) {
                throw new IllegalStateException("Location at index " + index + " is already committed");
            }
        }
        for (int i = index + 1; i < this.yyCount; ++i) {
            if (null == this.yyColumns[i]) continue;
            throw new IllegalStateException("Location at index " + index + " is already committed");
        }
        c = this.column(index);
        c.file = file;
        c.line = line;
        c.column = column;
    }

    public final void setLocation(Locatable locatable, int index) {
        if (null != locatable && !locatable.hasLocation()) {
            Column c = this.column(index);
            locatable.setLocation(new Location(c.file, c.line, c.column));
        }
    }

    protected final <T> T apply(Pair<Action<T>> actions, T seed) {
        while (!actions.isEmpty()) {
            seed = actions.head().run(seed);
            actions = actions.tail();
        }
        return seed;
    }

    protected final <T extends Locatable> T apply(Pair<Action<T>> actions, T seed, int index) {
        if (!actions.isEmpty()) {
            Location loc = this.location(index);
            do {
                seed = (Locatable)actions.head().run(seed);
                seed.setLocation(loc);
            } while (!(actions = actions.tail()).isEmpty());
        }
        return (T)seed;
    }

    public final String format(ParseError error) throws IOException {
        StringBuilder buf = new StringBuilder();
        Column c = null;
        if (-1 != error.index) {
            c = this.column(error.index);
            buf.append(c.file);
            buf.append(':');
            buf.append(c.line);
            buf.append(':');
            buf.append(c.column);
            buf.append(": ");
        }
        buf.append("error: ");
        buf.append(error.msg);
        if (-1 != error.index) {
            int i;
            String line = this.lineAt(error.index);
            int size2 = line.length();
            buf.append(NEWLINE);
            for (i = 0; i < size2; ++i) {
                buf.append(line.charAt(i));
            }
            buf.append(NEWLINE);
            for (i = 1; i < c.column; ++i) {
                buf.append(' ');
            }
            buf.append('^');
            buf.append(NEWLINE);
        }
        return buf.toString();
    }

    public final void signal(ParseError error) throws ParseException, IOException {
        throw new ParseException(this.format(error));
    }

    public final Object value(Result r) throws ParseException, IOException {
        if (!r.hasValue()) {
            this.signal(r.parseError());
        }
        return r.semanticValue();
    }

    protected final String peek(int index) {
        int limit;
        int n = limit = this.yyEOF ? this.yyCount - 1 : this.yyCount;
        if (index >= limit) {
            return "";
        }
        limit = Math.min(index + 20, limit);
        return new String(this.yyData, index, limit - index);
    }

    protected static final <T> T cast(Object o) {
        return (T)o;
    }

    protected static final <T> Pair<T> cast(Pair<?> p) {
        return p;
    }
}

