/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.parsing;

import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.xml.parsing.TokenTests;

public abstract class TokenTests$class {
    public static final boolean isSpace(TokenTests $this, char ch) {
        boolean bl;
        switch (ch) {
            default: {
                bl = false;
                break;
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean isSpace(TokenTests $this, Seq cs) {
        return cs.nonEmpty() && cs.forall(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TokenTests $outer;

            public final boolean apply(char ch) {
                return this.$outer.isSpace(ch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static boolean isAlpha(TokenTests $this, char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isAlphaDigit(TokenTests $this, char c) {
        return $this.isAlpha(c) || c >= '0' && c <= '9';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNameChar(TokenTests $this, char ch) {
        boolean bl;
        if ($this.isNameStart(ch)) return true;
        byte by2 = (byte)Character.getType(ch);
        switch (by2) {
            default: {
                Predef$ predef$ = Predef$.MODULE$;
                bl = new StringOps(".-:").contains(BoxesRunTime.boxToCharacter(ch));
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        if (!bl) return false;
        return true;
    }

    public static boolean isNameStart(TokenTests $this, char ch) {
        boolean bl;
        byte by2 = (byte)Character.getType(ch);
        switch (by2) {
            default: {
                if (ch == '_') {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 10: {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isName(TokenTests $this, String s2) {
        Predef$ predef$ = Predef$.MODULE$;
        if (!new StringOps(s2).nonEmpty()) return false;
        Predef$ predef$2 = Predef$.MODULE$;
        if (!$this.isNameStart(BoxesRunTime.unboxToChar(new StringOps(s2).head()))) return false;
        Predef$ predef$3 = Predef$.MODULE$;
        String string2 = (String)new StringOps(s2).tail();
        Predef$ predef$4 = Predef$.MODULE$;
        if (!new StringOps(string2).forall((Function1<Object, Object>)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TokenTests $outer;

            public final boolean apply(char ch) {
                return this.$outer.isNameChar(ch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPubIDChar(TokenTests $this, char ch) {
        if ($this.isAlphaDigit(ch)) return true;
        if ($this.isSpace(ch)) {
            if (ch != '\t') return true;
        }
        Predef$ predef$ = Predef$.MODULE$;
        if (!new StringOps("-\\()+,./:=?;!*#@$_%").contains(BoxesRunTime.boxToCharacter(ch))) return false;
        return true;
    }

    public static boolean isValidIANAEncoding(TokenTests $this, Seq ianaEncoding) {
        return ianaEncoding.nonEmpty() && $this.isAlpha(BoxesRunTime.unboxToChar(ianaEncoding.head())) && ((IterableLike)ianaEncoding.tail()).forall(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TokenTests $outer;

            public final boolean apply(char c) {
                return TokenTests$class.charOK$1(this.$outer, c);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static boolean checkSysID(TokenTests $this, String s2) {
        return ((List)List$.MODULE$.apply(Predef$.MODULE$.wrapCharArray(new char[]{'\"', '\''}))).exists(new Serializable($this, s2){
            public static final long serialVersionUID = 0L;
            private final String s$1;

            public final boolean apply(char c) {
                String string2 = this.s$1;
                Predef$ predef$ = Predef$.MODULE$;
                return !new StringOps(string2).contains(BoxesRunTime.boxToCharacter(c));
            }
            {
                this.s$1 = s$1;
            }
        });
    }

    public static boolean checkPubID(TokenTests $this, String s2) {
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps(s2).forall((Function1<Object, Object>)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TokenTests $outer;

            public final boolean apply(char ch) {
                return this.$outer.isPubIDChar(ch);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean charOK$1(TokenTests $this, char c) {
        if ($this.isAlphaDigit(c)) return true;
        Predef$ predef$ = Predef$.MODULE$;
        if (!new StringOps("._-").contains(BoxesRunTime.boxToCharacter(c))) return false;
        return true;
    }

    public static void $init$(TokenTests $this) {
    }
}

