/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.util;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.wikidata.wdtk.util.CompressionType;
import org.wikidata.wdtk.util.DirectoryManager;

public class DirectoryManagerImpl
implements DirectoryManager {
    final Path directory;

    public DirectoryManagerImpl(String baseDirectory) throws IOException {
        this(Paths.get(baseDirectory, new String[0]));
    }

    public DirectoryManagerImpl(Path baseDirectory) throws IOException {
        this.directory = baseDirectory;
        this.createDirectory(this.directory);
    }

    public String toString() {
        return this.directory.toString();
    }

    @Override
    public DirectoryManager getSubdirectoryManager(String subdirectoryName) throws IOException {
        return new DirectoryManagerImpl(this.directory.resolve(subdirectoryName));
    }

    @Override
    public boolean hasSubdirectory(String subdirectoryName) {
        Path subdirectoryPath = this.directory.resolve(subdirectoryName);
        return Files.isDirectory(subdirectoryPath, new LinkOption[0]);
    }

    @Override
    public boolean hasFile(String fileName) {
        Path filePath = this.directory.resolve(fileName);
        return Files.isRegularFile(filePath, new LinkOption[0]);
    }

    @Override
    public long createFile(String fileName, InputStream inputStream2) throws IOException {
        long fileSize;
        Path filePath = this.directory.resolve(fileName);
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream2);
             FileChannel fc = FileChannel.open(filePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
            fileSize = fc.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        return fileSize;
    }

    @Override
    public long createFileAtomic(String fileName, InputStream inputStream2) throws IOException {
        long fileSize;
        Path filePath = this.directory.resolve(fileName);
        Path fileTempPath = this.directory.resolve(fileName + ".part");
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream2);
             FileChannel fc = FileChannel.open(fileTempPath, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            fileSize = fc.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        Files.move(fileTempPath, filePath, new CopyOption[0]);
        return fileSize;
    }

    @Override
    public void createFile(String fileName, String fileContents) throws IOException {
        Path filePath = this.directory.resolve(fileName);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(filePath, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
            bufferedWriter.write(fileContents);
        }
    }

    @Override
    public InputStream getInputStreamForFile(String fileName, CompressionType compressionType) throws IOException {
        Path filePath = this.directory.resolve(fileName);
        InputStream fileInputStream = Files.newInputStream(filePath, StandardOpenOption.READ);
        switch (compressionType) {
            case NONE: {
                return fileInputStream;
            }
            case GZIP: {
                return new GZIPInputStream(fileInputStream);
            }
            case BZ2: {
                return new BZip2CompressorInputStream(new BufferedInputStream(fileInputStream));
            }
        }
        throw new IllegalArgumentException("Unsupported compresion type: " + (Object)((Object)compressionType));
    }

    @Override
    public List<String> getSubdirectories(String glob) throws IOException {
        ArrayList<String> result2 = new ArrayList<String>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.directory, glob);){
            for (Path entry : directoryStream) {
                if (!Files.isDirectory(entry, new LinkOption[0])) continue;
                result2.add(entry.getFileName().toString());
            }
        }
        return result2;
    }

    void createDirectory(Path path) throws IOException {
        block2: {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(path, new LinkOption[0])) break block2;
                throw e;
            }
        }
    }
}

