/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.storage.dbquery;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.wikidata.wdtk.storage.dbquery.PairTrie;
import org.wikidata.wdtk.storage.dbquery.TrieIterator;
import org.wikidata.wdtk.storage.dbquery.TripleTrie;

public class TripleTrieIterator
implements TrieIterator {
    final TripleTrie tripleTrie;
    Iterator<Map.Entry<Integer, PairTrie>> levelOneIterator;
    Map.Entry<Integer, PairTrie> currentLevelOneEntry;
    Iterator<int[]> levelTwoIterator;
    int[] currentLevelTwoEntry = null;
    int currentLevelTwoIntervalOffset = 0;
    int currentLevelThreeOffset = 0;
    int level = 1;

    public TripleTrieIterator(TripleTrie tripleTrie) {
        this.tripleTrie = tripleTrie;
        this.levelOneIterator = tripleTrie.levelOne.entrySet().iterator();
        this.currentLevelOneEntry = this.levelOneIterator.next();
    }

    @Override
    public int getKey() {
        if (this.level == 1) {
            return this.currentLevelOneEntry.getKey();
        }
        if (this.level == 2) {
            return this.currentLevelTwoEntry[0] + this.currentLevelTwoIntervalOffset;
        }
        if (this.currentLevelTwoEntry.length == 2) {
            return this.currentLevelTwoEntry[1];
        }
        if (this.currentLevelTwoEntry.length == 3) {
            return this.currentLevelTwoEntry[2];
        }
        return this.currentLevelTwoEntry[2 + this.currentLevelThreeOffset];
    }

    @Override
    public int getKey(int level) {
        if (level > this.level) {
            throw new IndexOutOfBoundsException("Cannot access keys for level " + level + " since it is below the current level " + this.level);
        }
        if (level == 1) {
            return this.currentLevelOneEntry.getKey();
        }
        if (level == 2) {
            return this.currentLevelTwoEntry[0] + this.currentLevelTwoIntervalOffset;
        }
        if (this.currentLevelTwoEntry.length == 2) {
            return this.currentLevelTwoEntry[1];
        }
        if (this.currentLevelTwoEntry.length == 3) {
            return this.currentLevelTwoEntry[2];
        }
        return this.currentLevelTwoEntry[2 + this.currentLevelThreeOffset];
    }

    @Override
    public void next() {
        if (this.level == 1) {
            this.currentLevelOneEntry = this.levelOneIterator.next();
        } else if (this.level == 2) {
            if (this.currentLevelTwoEntry.length == 3 && this.currentLevelTwoEntry[0] + this.currentLevelTwoIntervalOffset < this.currentLevelTwoEntry[1]) {
                ++this.currentLevelTwoIntervalOffset;
            } else {
                this.currentLevelTwoEntry = this.levelTwoIterator.next();
                this.currentLevelTwoIntervalOffset = 0;
            }
        } else {
            ++this.currentLevelThreeOffset;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.level == 1) {
            return this.levelOneIterator.hasNext();
        }
        if (this.level == 2) {
            if (this.currentLevelTwoEntry.length == 3) {
                return this.currentLevelTwoEntry[0] + this.currentLevelTwoIntervalOffset < this.currentLevelTwoEntry[1];
            }
            return this.levelTwoIterator.hasNext();
        }
        if (this.currentLevelTwoEntry.length == 2) {
            return false;
        }
        if (this.currentLevelTwoEntry.length == 3) {
            return false;
        }
        return this.currentLevelThreeOffset + 1 < this.currentLevelTwoEntry[1];
    }

    @Override
    public boolean seek(int lowerBound) {
        if (this.level == 1) {
            this.levelOneIterator = this.tripleTrie.levelOne.tailMap(lowerBound).entrySet().iterator();
            if (!this.levelOneIterator.hasNext()) {
                return false;
            }
            this.currentLevelOneEntry = this.levelOneIterator.next();
        } else if (this.level == 2) {
            int[] lowerBoundArray = new int[]{lowerBound};
            int[] previous = this.currentLevelOneEntry.getValue().nodes.floor(lowerBoundArray);
            if (previous != null && previous.length == 3 && previous[1] >= lowerBound) {
                this.levelTwoIterator = this.currentLevelOneEntry.getValue().nodes.tailSet(lowerBoundArray).iterator();
                this.currentLevelTwoEntry = previous;
                this.currentLevelTwoIntervalOffset = lowerBound - previous[0];
            } else {
                this.levelTwoIterator = this.currentLevelOneEntry.getValue().nodes.tailSet(lowerBoundArray).iterator();
                if (!this.levelTwoIterator.hasNext()) {
                    return false;
                }
                this.currentLevelTwoEntry = this.levelTwoIterator.next();
                this.currentLevelTwoIntervalOffset = 0;
            }
        } else {
            if (this.currentLevelTwoEntry.length == 2) {
                return this.currentLevelTwoEntry[1] >= lowerBound;
            }
            if (this.currentLevelTwoEntry.length == 3) {
                return this.currentLevelTwoEntry[2] >= lowerBound;
            }
            int index = Arrays.binarySearch(this.currentLevelTwoEntry, 2, this.currentLevelTwoEntry[1] + 1, lowerBound);
            if (index > 0) {
                this.currentLevelThreeOffset = index - 2;
            } else if (-index - 3 < this.currentLevelTwoEntry[1]) {
                this.currentLevelThreeOffset = -index - 3;
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public void down() {
        if (this.level == 1) {
            this.currentLevelOneEntry.getValue().sortAllPairs();
            this.levelTwoIterator = this.currentLevelOneEntry.getValue().iterator();
            this.currentLevelTwoEntry = this.levelTwoIterator.next();
            this.currentLevelTwoIntervalOffset = 0;
            ++this.level;
        } else if (this.level == 2) {
            this.currentLevelThreeOffset = 0;
            ++this.level;
            if (this.currentLevelTwoEntry.length > 3) {
                System.out.println("Size: " + this.currentLevelTwoEntry[1]);
            }
        }
    }

    @Override
    public void up() {
        if (this.level > 1) {
            --this.level;
        }
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public boolean hasDown() {
        return this.level < 3;
    }

    @Override
    public boolean hasUp() {
        return this.level > 1;
    }

    public static void printTrie(TrieIterator trie) {
        TripleTrieIterator.printTrieRecursive(trie, 1);
    }

    static void printTrieRecursive(TrieIterator trie, int level) {
        boolean done = false;
        while (!done) {
            System.out.println(String.format("%1$" + 10 * level + "s", trie.getKey()));
            if (trie.hasDown()) {
                trie.down();
                TripleTrieIterator.printTrieRecursive(trie, level + 1);
                trie.up();
            }
            if (trie.hasNext()) {
                trie.next();
                continue;
            }
            done = true;
        }
    }
}

